/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.table.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.Serializable;
import java.sql.JDBCType;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.eventmesh.connector.jdbc.table.catalog.EventMeshDataTypeJsonDeserializer;
import org.apache.eventmesh.connector.jdbc.table.catalog.EventMeshDataTypeJsonSerializer;
import org.apache.eventmesh.connector.jdbc.table.catalog.Options;
import org.apache.eventmesh.connector.jdbc.table.type.EventMeshDataType;

public class Column<Col extends Column>
implements Serializable {
    protected String name;
    @JsonSerialize(using=EventMeshDataTypeJsonSerializer.class)
    @JsonDeserialize(using=EventMeshDataTypeJsonDeserializer.class)
    protected EventMeshDataType dataType;
    protected JDBCType jdbcType;
    protected Long columnLength;
    protected Integer decimal;
    protected boolean notNull = false;
    protected String comment;
    protected Object defaultValue;
    @JsonIgnore
    protected String defaultValueExpression;
    protected int order = 1;
    protected String charsetName;
    protected Boolean autoIncremented;
    protected Boolean generated;
    protected String collationName;
    protected List<String> enumValues;
    protected String nativeType;
    protected Options options;

    public Column(String name, EventMeshDataType dataType, JDBCType jdbcType, Long columnLength, Integer decimal, boolean notNull, String comment, Object defaultValue, String defaultValueExpression, int order, String charsetName, boolean autoIncremented, boolean generated, String collationName) {
        this.name = name;
        this.dataType = dataType;
        this.jdbcType = jdbcType;
        this.columnLength = columnLength;
        this.decimal = decimal;
        this.notNull = notNull;
        this.comment = comment;
        this.defaultValue = defaultValue;
        this.defaultValueExpression = defaultValueExpression;
        this.order = order;
        this.charsetName = charsetName;
        this.autoIncremented = autoIncremented;
        this.generated = generated;
        this.collationName = collationName;
    }

    private Column(Builder builder) {
        this.name = builder.name;
        this.dataType = builder.dataType;
        this.jdbcType = builder.jdbcType;
        this.columnLength = builder.columnLength;
        this.decimal = builder.decimal;
        this.notNull = builder.notNull;
        this.comment = builder.comment;
        this.defaultValue = builder.defaultValue;
        this.defaultValueExpression = builder.defaultValueExpression;
        this.order = builder.order;
        this.charsetName = builder.charsetName;
        this.autoIncremented = builder.autoIncremented;
        this.generated = builder.generated;
        this.collationName = builder.collationName;
        this.enumValues = builder.enumValues;
        this.nativeType = builder.nativeType;
        this.options = builder.options;
    }

    public boolean isAutoIncremented() {
        return Optional.ofNullable(this.autoIncremented).orElse(false);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Col clone() {
        return null;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public EventMeshDataType getDataType() {
        return this.dataType;
    }

    @Generated
    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    @Generated
    public Long getColumnLength() {
        return this.columnLength;
    }

    @Generated
    public Integer getDecimal() {
        return this.decimal;
    }

    @Generated
    public boolean isNotNull() {
        return this.notNull;
    }

    @Generated
    public String getComment() {
        return this.comment;
    }

    @Generated
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public String getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getCharsetName() {
        return this.charsetName;
    }

    @Generated
    public Boolean getAutoIncremented() {
        return this.autoIncremented;
    }

    @Generated
    public Boolean getGenerated() {
        return this.generated;
    }

    @Generated
    public String getCollationName() {
        return this.collationName;
    }

    @Generated
    public List<String> getEnumValues() {
        return this.enumValues;
    }

    @Generated
    public String getNativeType() {
        return this.nativeType;
    }

    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonDeserialize(using=EventMeshDataTypeJsonDeserializer.class)
    @Generated
    public void setDataType(EventMeshDataType dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setJdbcType(JDBCType jdbcType) {
        this.jdbcType = jdbcType;
    }

    @Generated
    public void setColumnLength(Long columnLength) {
        this.columnLength = columnLength;
    }

    @Generated
    public void setDecimal(Integer decimal) {
        this.decimal = decimal;
    }

    @Generated
    public void setNotNull(boolean notNull) {
        this.notNull = notNull;
    }

    @Generated
    public void setComment(String comment) {
        this.comment = comment;
    }

    @Generated
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    @JsonIgnore
    @Generated
    public void setDefaultValueExpression(String defaultValueExpression) {
        this.defaultValueExpression = defaultValueExpression;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    @Generated
    public void setAutoIncremented(Boolean autoIncremented) {
        this.autoIncremented = autoIncremented;
    }

    @Generated
    public void setGenerated(Boolean generated) {
        this.generated = generated;
    }

    @Generated
    public void setCollationName(String collationName) {
        this.collationName = collationName;
    }

    @Generated
    public void setEnumValues(List<String> enumValues) {
        this.enumValues = enumValues;
    }

    @Generated
    public void setNativeType(String nativeType) {
        this.nativeType = nativeType;
    }

    @Generated
    public void setOptions(Options options) {
        this.options = options;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotNull() != other.isNotNull()) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        Long this$columnLength = this.getColumnLength();
        Long other$columnLength = other.getColumnLength();
        if (this$columnLength == null ? other$columnLength != null : !((Object)this$columnLength).equals(other$columnLength)) {
            return false;
        }
        Integer this$decimal = this.getDecimal();
        Integer other$decimal = other.getDecimal();
        if (this$decimal == null ? other$decimal != null : !((Object)this$decimal).equals(other$decimal)) {
            return false;
        }
        Boolean this$autoIncremented = this.getAutoIncremented();
        Boolean other$autoIncremented = other.getAutoIncremented();
        if (this$autoIncremented == null ? other$autoIncremented != null : !((Object)this$autoIncremented).equals(other$autoIncremented)) {
            return false;
        }
        Boolean this$generated = this.getGenerated();
        Boolean other$generated = other.getGenerated();
        if (this$generated == null ? other$generated != null : !((Object)this$generated).equals(other$generated)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        EventMeshDataType this$dataType = this.getDataType();
        EventMeshDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        JDBCType this$jdbcType = this.getJdbcType();
        JDBCType other$jdbcType = other.getJdbcType();
        if (this$jdbcType == null ? other$jdbcType != null : !this$jdbcType.equals(other$jdbcType)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        Object this$defaultValue = this.getDefaultValue();
        Object other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$defaultValueExpression = this.getDefaultValueExpression();
        String other$defaultValueExpression = other.getDefaultValueExpression();
        if (this$defaultValueExpression == null ? other$defaultValueExpression != null : !this$defaultValueExpression.equals(other$defaultValueExpression)) {
            return false;
        }
        String this$charsetName = this.getCharsetName();
        String other$charsetName = other.getCharsetName();
        if (this$charsetName == null ? other$charsetName != null : !this$charsetName.equals(other$charsetName)) {
            return false;
        }
        String this$collationName = this.getCollationName();
        String other$collationName = other.getCollationName();
        if (this$collationName == null ? other$collationName != null : !this$collationName.equals(other$collationName)) {
            return false;
        }
        List<String> this$enumValues = this.getEnumValues();
        List<String> other$enumValues = other.getEnumValues();
        if (this$enumValues == null ? other$enumValues != null : !((Object)this$enumValues).equals(other$enumValues)) {
            return false;
        }
        String this$nativeType = this.getNativeType();
        String other$nativeType = other.getNativeType();
        if (this$nativeType == null ? other$nativeType != null : !this$nativeType.equals(other$nativeType)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotNull() ? 79 : 97);
        result = result * 59 + this.getOrder();
        Long $columnLength = this.getColumnLength();
        result = result * 59 + ($columnLength == null ? 43 : ((Object)$columnLength).hashCode());
        Integer $decimal = this.getDecimal();
        result = result * 59 + ($decimal == null ? 43 : ((Object)$decimal).hashCode());
        Boolean $autoIncremented = this.getAutoIncremented();
        result = result * 59 + ($autoIncremented == null ? 43 : ((Object)$autoIncremented).hashCode());
        Boolean $generated = this.getGenerated();
        result = result * 59 + ($generated == null ? 43 : ((Object)$generated).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        EventMeshDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        JDBCType $jdbcType = this.getJdbcType();
        result = result * 59 + ($jdbcType == null ? 43 : $jdbcType.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        Object $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $defaultValueExpression = this.getDefaultValueExpression();
        result = result * 59 + ($defaultValueExpression == null ? 43 : $defaultValueExpression.hashCode());
        String $charsetName = this.getCharsetName();
        result = result * 59 + ($charsetName == null ? 43 : $charsetName.hashCode());
        String $collationName = this.getCollationName();
        result = result * 59 + ($collationName == null ? 43 : $collationName.hashCode());
        List<String> $enumValues = this.getEnumValues();
        result = result * 59 + ($enumValues == null ? 43 : ((Object)$enumValues).hashCode());
        String $nativeType = this.getNativeType();
        result = result * 59 + ($nativeType == null ? 43 : $nativeType.hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Column(name=" + this.getName() + ", dataType=" + this.getDataType() + ", jdbcType=" + this.getJdbcType() + ", columnLength=" + this.getColumnLength() + ", decimal=" + this.getDecimal() + ", notNull=" + this.isNotNull() + ", comment=" + this.getComment() + ", defaultValue=" + this.getDefaultValue() + ", defaultValueExpression=" + this.getDefaultValueExpression() + ", order=" + this.getOrder() + ", charsetName=" + this.getCharsetName() + ", autoIncremented=" + this.getAutoIncremented() + ", generated=" + this.getGenerated() + ", collationName=" + this.getCollationName() + ", enumValues=" + this.getEnumValues() + ", nativeType=" + this.getNativeType() + ", options=" + this.getOptions() + ")";
    }

    @Generated
    public Column(String name, EventMeshDataType dataType, JDBCType jdbcType, Long columnLength, Integer decimal, boolean notNull, String comment, Object defaultValue, String defaultValueExpression, int order, String charsetName, Boolean autoIncremented, Boolean generated, String collationName, List<String> enumValues, String nativeType, Options options) {
        this.name = name;
        this.dataType = dataType;
        this.jdbcType = jdbcType;
        this.columnLength = columnLength;
        this.decimal = decimal;
        this.notNull = notNull;
        this.comment = comment;
        this.defaultValue = defaultValue;
        this.defaultValueExpression = defaultValueExpression;
        this.order = order;
        this.charsetName = charsetName;
        this.autoIncremented = autoIncremented;
        this.generated = generated;
        this.collationName = collationName;
        this.enumValues = enumValues;
        this.nativeType = nativeType;
        this.options = options;
    }

    @Generated
    public Column() {
    }

    public static class Builder {
        protected String name;
        protected EventMeshDataType dataType;
        protected JDBCType jdbcType;
        protected Long columnLength;
        protected Integer decimal;
        protected boolean notNull = false;
        protected String comment;
        protected Object defaultValue;
        protected String defaultValueExpression;
        protected int order = 1;
        protected String charsetName;
        protected Boolean autoIncremented;
        protected Boolean generated;
        protected String collationName;
        protected List<String> enumValues;
        protected String nativeType;
        protected Options options;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDataType(EventMeshDataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder withJdbcType(JDBCType jdbcType) {
            this.jdbcType = jdbcType;
            return this;
        }

        public Builder withColumnLength(Long columnLength) {
            this.columnLength = columnLength;
            return this;
        }

        public Builder withDecimal(Integer decimal) {
            this.decimal = decimal;
            return this;
        }

        public Builder withNotNull(boolean notNull) {
            this.notNull = notNull;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder withDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder withDefaultValueExpression(String defaultValueExpression) {
            this.defaultValueExpression = defaultValueExpression;
            return this;
        }

        public Builder withOrder(int order) {
            this.order = order;
            return this;
        }

        public Builder withCharsetName(String charsetName) {
            this.charsetName = charsetName;
            return this;
        }

        public Builder withAutoIncremented(boolean autoIncremented) {
            this.autoIncremented = autoIncremented;
            return this;
        }

        public Builder withGenerated(boolean generated) {
            this.generated = generated;
            return this;
        }

        public Builder withCollationName(String collationName) {
            this.collationName = collationName;
            return this;
        }

        public Builder withEnumValues(List<String> enumValues) {
            this.enumValues = enumValues;
            return this;
        }

        public Builder withNativeType(String nativeType) {
            this.nativeType = nativeType;
            return this;
        }

        public Builder withOptions(Options options) {
            this.options = options;
            return this;
        }

        public Column build() {
            return new Column(this);
        }
    }
}

