/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.AbstractType;

public class BitType
extends AbstractType<byte[]> {
    public static final BitType INSTANCE = new BitType();

    public BitType() {
        super(byte[].class, SQLType.BIT, "BIT");
    }

    @Override
    public String getDefaultValue(DatabaseDialect<?> databaseDialect, Column<?> column) {
        return column.getDefaultValue() == null ? " NULL " : String.format("b'%s'", column.getDefaultValue());
    }

    @Override
    public String getTypeName(Column<?> column) {
        Long columnLength = column.getColumnLength();
        return String.format("bit(%d)", Optional.ofNullable(columnLength).orElse(1L).intValue());
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList("BIT", "bit");
    }

    @Override
    public Object convert2DatabaseTypeValue(Object value) {
        String strValue = (String)value;
        return Base64.getDecoder().decode(strValue);
    }
}

