/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.type.mysql;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.type.SQLType;
import org.apache.eventmesh.connector.jdbc.type.AbstractType;

public class TinyIntType
extends AbstractType<Byte> {
    public static final TinyIntType INSTANCE = new TinyIntType();

    public TinyIntType() {
        super(Byte.class, SQLType.TINYINT, "TINYINT");
    }

    @Override
    public List<String> ofRegistrationKeys() {
        return Arrays.asList(this.getName(), "tinyint");
    }

    @Override
    public String getTypeName(Column<?> column) {
        int size = Optional.ofNullable(column.getColumnLength()).orElse(0L).intValue();
        if (size > 0) {
            return String.format("tinyint(%d)", size);
        }
        return "tinyint";
    }
}

