/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.utils;

import lombok.Generated;

public final class JdbcStringUtils {
    public static boolean isWrapped(String possiblyWrapped) {
        if (possiblyWrapped == null || possiblyWrapped.length() < 2) {
            return false;
        }
        char firstChar = possiblyWrapped.charAt(0);
        char lastChar = possiblyWrapped.charAt(possiblyWrapped.length() - 1);
        return firstChar == '`' && lastChar == '`' || firstChar == '\'' && lastChar == '\'' || firstChar == '\"' && lastChar == '\"';
    }

    public static boolean isWrapped(char c) {
        return c == '\'' || c == '\"' || c == '`';
    }

    public static String withoutWrapper(String possiblyWrapped) {
        return JdbcStringUtils.isWrapped(possiblyWrapped) ? possiblyWrapped.substring(1, possiblyWrapped.length() - 1) : possiblyWrapped;
    }

    public static int compareVersion(String versionX, String versionY) {
        String[] firstVersionParts = versionX.split("\\.");
        String[] secondVersionParts = versionY.split("\\.");
        int maxLength = Math.max(firstVersionParts.length, secondVersionParts.length);
        for (int i = 0; i < maxLength; ++i) {
            int secondVersionNumber;
            int firstVersionNumber = JdbcStringUtils.getPartAsNumber(firstVersionParts, i);
            if (firstVersionNumber == (secondVersionNumber = JdbcStringUtils.getPartAsNumber(secondVersionParts, i))) continue;
            return Integer.signum(firstVersionNumber - secondVersionNumber);
        }
        return 0;
    }

    private static int getPartAsNumber(String[] parts, int index) {
        return index < parts.length ? Integer.parseInt(parts[index]) : 0;
    }

    @Generated
    private JdbcStringUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

