/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.ProtocolVersion;
import org.apache.eventmesh.common.protocol.http.header.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConvertsUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConvertsUtils.class);

    public Map<String, Object> httpMapConverts(Header header, ProtocolKey protocolKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> headerClass = header.getClass();
        Class<?> protocolKeyClass = protocolKey.getClass();
        Field[] headerFields = headerClass.getDeclaredFields();
        Field[] protocolKeyFields = protocolKeyClass.getDeclaredFields();
        for (Field headerField : headerFields) {
            headerField.setAccessible(true);
            try {
                String headerFieldName = headerField.getName();
                Object headerFieldValue = headerField.get(header);
                for (Field protocolKeyField : protocolKeyFields) {
                    protocolKeyField.setAccessible(true);
                    String protocolKeyValue = protocolKeyField.get(protocolKey).toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)headerFieldName, (CharSequence)protocolKeyValue)) continue;
                    map.put(protocolKeyValue, headerFieldValue);
                }
                EnumSet<ProtocolKey.ClientInstanceKey> clientInstanceKeys = EnumSet.allOf(ProtocolKey.ClientInstanceKey.class);
                for (ProtocolKey.ClientInstanceKey clientInstanceKey : clientInstanceKeys) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)headerFieldName, (CharSequence)clientInstanceKey.getKey())) continue;
                    map.put(clientInstanceKey.getKey(), headerFieldValue);
                }
            }
            catch (IllegalAccessException e) {
                log.error("http map conversion failed.", (Throwable)e);
            }
        }
        return map;
    }

    public Map<String, Object> httpMapConverts(Header header, ProtocolKey protocolKey, ProtocolKey.EventMeshInstanceKey eventMeshInstanceKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> headerClass = header.getClass();
        Class<?> protocolKeyClass = protocolKey.getClass();
        Class<?> eventMeshInstanceKeyClass = eventMeshInstanceKey.getClass();
        Field[] headerFields = headerClass.getDeclaredFields();
        Field[] protocolKeyFields = protocolKeyClass.getDeclaredFields();
        Field[] eventMeshInstanceKeyFields = eventMeshInstanceKeyClass.getDeclaredFields();
        for (Field headerField : headerFields) {
            headerField.setAccessible(true);
            try {
                String headerFieldName = headerField.getName();
                Object headerFieldValue = headerField.get(header);
                for (Field protocolKeyField : protocolKeyFields) {
                    protocolKeyField.setAccessible(true);
                    String protocolKeyFieldValue = protocolKeyField.get(protocolKey).toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)headerFieldName, (CharSequence)protocolKeyFieldValue)) continue;
                    map.put(protocolKeyFieldValue, headerFieldValue);
                }
                for (Field eventMeshInstanceKeyField : eventMeshInstanceKeyFields) {
                    eventMeshInstanceKeyField.setAccessible(true);
                    String eventMeshInstanceKeyValue = eventMeshInstanceKeyField.get(eventMeshInstanceKey).toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)headerFieldName, (CharSequence)eventMeshInstanceKeyValue)) continue;
                    map.put(eventMeshInstanceKeyValue, headerFieldValue);
                }
            }
            catch (IllegalAccessException e) {
                log.error("http map conversion failed.", (Throwable)e);
            }
        }
        return map;
    }

    public Header httpHeaderConverts(Header header, Map<String, Object> headerParam) {
        Field[] headerFields;
        Class<?> headerClass = header.getClass();
        ProtocolKey protocolKey = new ProtocolKey();
        Class<?> protocolKeyClass = protocolKey.getClass();
        Field[] protocolKeyFields = protocolKeyClass.getDeclaredFields();
        for (Field headerField : headerFields = headerClass.getDeclaredFields()) {
            headerField.setAccessible(true);
            String headerFieldName = headerField.getName();
            try {
                this.setFiledValue(header, headerParam, protocolKey, protocolKeyFields, headerField, headerFieldName);
                EnumSet<ProtocolKey.ClientInstanceKey> clientInstanceKeys = EnumSet.allOf(ProtocolKey.ClientInstanceKey.class);
                for (ProtocolKey.ClientInstanceKey clientInstanceKey : clientInstanceKeys) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)headerFieldName, (CharSequence)clientInstanceKey.getKey())) continue;
                    headerField.set(header, MapUtils.getString(headerParam, (Object)clientInstanceKey.getKey()));
                }
            }
            catch (IllegalAccessException e) {
                log.error("http header builder conversion failed.", (Throwable)e);
            }
        }
        return header;
    }

    public Header httpHeaderConverts(Header header, Map<String, Object> headerParam, ProtocolKey.EventMeshInstanceKey eventMeshInstanceKey) {
        Class<?> headerClass = header.getClass();
        ProtocolKey protocolKey = new ProtocolKey();
        Class<?> protocolKeyClass = protocolKey.getClass();
        Class<?> eventMeshInstanceKeyClass = eventMeshInstanceKey.getClass();
        Field[] protocolKeyFields = protocolKeyClass.getDeclaredFields();
        Field[] headerFields = headerClass.getDeclaredFields();
        Field[] eventMeshInstanceKeyFields = eventMeshInstanceKeyClass.getDeclaredFields();
        for (Field headerField : headerFields) {
            headerField.setAccessible(true);
            String headerFieldName = headerField.getName();
            try {
                this.setFiledValue(header, headerParam, protocolKey, protocolKeyFields, headerField, headerFieldName);
                for (Field eventMeshInstanceKeyField : eventMeshInstanceKeyFields) {
                    eventMeshInstanceKeyField.setAccessible(true);
                    String eventMeshInstanceKeyValue = eventMeshInstanceKeyField.get(eventMeshInstanceKey).toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)headerFieldName, (CharSequence)eventMeshInstanceKeyValue)) continue;
                    headerField.set(header, MapUtils.getString(headerParam, (Object)eventMeshInstanceKeyValue));
                }
            }
            catch (IllegalAccessException e) {
                log.error("http header builder conversion failed.", (Throwable)e);
            }
        }
        return header;
    }

    private void setFiledValue(Header header, Map<String, Object> headerParam, ProtocolKey protocolKey, Field[] protocolKeyFields, Field headerField, String headerFieldName) throws IllegalAccessException {
        block8: for (Field protocolKeyField : protocolKeyFields) {
            protocolKeyField.setAccessible(true);
            switch (headerFieldName) {
                case "version": {
                    ProtocolVersion protocolVersion = ProtocolVersion.get(MapUtils.getString(headerParam, (Object)"version"));
                    if (!Objects.nonNull((Object)protocolVersion)) continue block8;
                    headerField.set(header, (Object)protocolVersion);
                    continue block8;
                }
                case "language": {
                    String language = StringUtils.isBlank((CharSequence)MapUtils.getString(headerParam, (Object)"language")) ? "JAVA" : MapUtils.getString(headerParam, (Object)"language");
                    headerField.set(header, language);
                    continue block8;
                }
                default: {
                    Object value;
                    String protocolKeyValue = protocolKeyField.get(protocolKey).toString();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)headerFieldName, (CharSequence)protocolKeyValue) || !Objects.nonNull(value = this.getValue(headerParam, protocolKeyValue))) continue block8;
                    headerField.set(header, value);
                }
            }
        }
    }

    private Object getValue(Map<String, Object> headerParam, String protocolKeyValue) {
        Object mapValue = headerParam.get(protocolKeyValue);
        Object value = null;
        if (mapValue instanceof Integer) {
            value = MapUtils.getIntValue(headerParam, (Object)protocolKeyValue);
        } else if (mapValue instanceof String) {
            value = MapUtils.getString(headerParam, (Object)protocolKeyValue);
        }
        return value;
    }
}

