/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler;

import com.navercorp.pinpoint.bootstrap.Agent;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.plugin.util.SocketAddressUtils;
import com.navercorp.pinpoint.common.profiler.concurrent.PinpointThreadFactory;
import com.navercorp.pinpoint.profiler.AgentStatus;
import com.navercorp.pinpoint.profiler.ShutdownHookRegister;
import com.navercorp.pinpoint.profiler.context.module.ApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.DefaultModuleFactoryResolver;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactory;
import com.navercorp.pinpoint.profiler.context.provider.ShutdownHookRegisterProvider;
import com.navercorp.pinpoint.profiler.logging.Log4j2LoggingSystem;
import com.navercorp.pinpoint.profiler.logging.LoggingSystem;
import com.navercorp.pinpoint.profiler.util.SystemPropertyDumper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultAgent
implements Agent {
    private final LoggingSystem loggingSystem;
    private final Logger logger;
    private final ProfilerConfig profilerConfig;
    private final ApplicationContext applicationContext;
    private final Object agentStatusLock = new Object();
    private volatile AgentStatus agentStatus;

    public DefaultAgent(AgentOption agentOption) {
        Objects.requireNonNull(agentOption, "agentOption");
        Objects.requireNonNull(agentOption.getInstrumentation(), "instrumentation");
        Objects.requireNonNull(agentOption.getProfilerConfig(), "profilerConfig");
        this.profilerConfig = agentOption.getProfilerConfig();
        Path logConfigPath = this.getLogConfigPath(this.profilerConfig);
        this.loggingSystem = this.newLoggingSystem(logConfigPath);
        this.loggingSystem.start();
        this.logger = LogManager.getLogger(this.getClass());
        this.dumpAgentOption(agentOption);
        this.dumpSystemProperties();
        this.dumpConfig(agentOption.getProfilerConfig());
        this.changeStatus(AgentStatus.INITIALIZING);
        this.preloadOnStartup();
        this.applicationContext = this.newApplicationContext(agentOption);
    }

    private void dumpAgentOption(AgentOption agentOption) {
        this.logger.info("AgentOption");
        this.logger.info("- agentId:{}", (Object)agentOption.getAgentId());
        this.logger.info("- applicationName:{}", (Object)agentOption.getApplicationName());
        this.logger.info("- agentName:{}", (Object)agentOption.getAgentName());
        this.logger.info("- isContainer:{}", (Object)agentOption.isContainer());
        this.logger.info("- instrumentation:{}", (Object)agentOption.getInstrumentation());
    }

    private LoggingSystem newLoggingSystem(Path profilePath) {
        return new Log4j2LoggingSystem(profilePath);
    }

    protected ApplicationContext newApplicationContext(AgentOption agentOption) {
        Objects.requireNonNull(agentOption, "agentOption");
        ProfilerConfig profilerConfig = Objects.requireNonNull(agentOption.getProfilerConfig(), "profilerConfig");
        DefaultModuleFactoryResolver moduleFactoryResolver = new DefaultModuleFactoryResolver(profilerConfig.getInjectionModuleFactoryClazzName());
        ModuleFactory moduleFactory = moduleFactoryResolver.resolve();
        return new DefaultApplicationContext(agentOption, moduleFactory);
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private void dumpSystemProperties() {
        SystemPropertyDumper dumper = new SystemPropertyDumper();
        dumper.dump();
    }

    private void dumpConfig(ProfilerConfig profilerConfig) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}", (Object)profilerConfig);
            Properties properties = profilerConfig.getProperties();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.logger.info("- {}={}", entry.getKey(), entry.getValue());
            }
        }
    }

    private void changeStatus(AgentStatus status) {
        this.agentStatus = status;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Agent status is changed. {}", (Object)status);
        }
    }

    private Path getLogConfigPath(ProfilerConfig config) {
        String location = config.readString("pinpoint.profiler.log.config.location", null);
        if (location == null) {
            throw new IllegalStateException("logPath($PINPOINT_DIR/profiles/${profile}/) not found");
        }
        return Paths.get(location, new String[0]);
    }

    private void preloadOnStartup() {
        SocketAddressUtils.getHostNameFirst(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.agentStatusLock;
        synchronized (object) {
            if (this.agentStatus != AgentStatus.INITIALIZING) {
                this.logger.warn("Agent already started.");
                return;
            }
            this.changeStatus(AgentStatus.RUNNING);
        }
        this.logger.info("Starting {} Agent.", (Object)"pinpoint");
        this.applicationContext.start();
    }

    public void registerStopHandler() {
        if (this.applicationContext instanceof DefaultApplicationContext) {
            this.logger.info("registerStopHandler");
            DefaultApplicationContext context = (DefaultApplicationContext)this.applicationContext;
            ShutdownHookRegisterProvider shutdownHookRegisterProvider = context.getShutdownHookRegisterProvider();
            ShutdownHookRegister shutdownHookRegister = shutdownHookRegisterProvider.get();
            PinpointThreadFactory pinpointThreadFactory = new PinpointThreadFactory("Pinpoint-shutdown-hook", false);
            Thread shutdownThread = pinpointThreadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    DefaultAgent.this.logger.info("stop() started. threadName:" + Thread.currentThread().getName());
                    DefaultAgent.this.stop();
                }
            });
            shutdownHookRegister.register(shutdownThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.agentStatusLock;
        synchronized (object) {
            if (this.agentStatus != AgentStatus.RUNNING) {
                this.logger.warn("Cannot stop agent. Current status = [{}]", (Object)this.agentStatus);
                return;
            }
            this.changeStatus(AgentStatus.STOPPED);
        }
        this.logger.info("Stopping {} Agent.", (Object)"pinpoint");
        this.applicationContext.close();
        if (this.profilerConfig.getStaticResourceCleanup()) {
            this.loggingSystem.stop();
        }
    }
}

