/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.errorhandler;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionKey {
    private static final String KEY_PATTERN = "%s.%s.%s";
    public static final String PREFIX = "profiler.ignore-error-handler";
    public static final String PATTERN_REGEX = "^(profiler).(ignore-error-handler).([A-Za-z0-9\\-_]+).([A-Za-z0-9\\-_.@]+)";
    public static final String CLASSNAME = "class-name";
    public static final String EXCEPTION_MESSAGE_CONTAINS = "exception-message@contains";
    public static final String NESTED = "nested";
    public static final String PARENT = "parent";

    public static String getKey(String errorHandlerId, String optionKey) {
        Objects.requireNonNull(errorHandlerId, "errorHandlerId");
        Objects.requireNonNull(optionKey, "optionKey");
        return String.format(KEY_PATTERN, PREFIX, errorHandlerId, optionKey);
    }

    public static String getClassName(String errorHandlerId) {
        return OptionKey.getKey(errorHandlerId, CLASSNAME);
    }

    public static String getExceptionMessageContains(String errorHandlerId) {
        return OptionKey.getKey(errorHandlerId, EXCEPTION_MESSAGE_CONTAINS);
    }

    public static String parseHandlerId(String pattern) {
        Pattern compile = Pattern.compile(PATTERN_REGEX);
        Matcher matcher = compile.matcher(pattern);
        if (matcher.find()) {
            return matcher.group(3);
        }
        return null;
    }
}

