/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.exception.storage;

import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionMetaData;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionMetaDataFactory;
import com.navercorp.pinpoint.profiler.context.exception.model.ExceptionWrapper;
import com.navercorp.pinpoint.profiler.context.exception.storage.ExceptionStorage;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.util.queue.ArrayBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BufferedExceptionStorage
implements ExceptionStorage {
    private static final Logger logger = LogManager.getLogger(BufferedExceptionStorage.class);
    private static final boolean isDebug = logger.isDebugEnabled();
    private final ArrayBuffer<ExceptionWrapper> buffer;
    private final EnhancedDataSender<MetaDataType, ResponseMessage> dataSender;
    private final ExceptionMetaDataFactory factory;

    public BufferedExceptionStorage(int bufferSize, EnhancedDataSender<MetaDataType, ResponseMessage> dataSender, ExceptionMetaDataFactory exceptionMetaDataFactory) {
        this.dataSender = Objects.requireNonNull(dataSender, "dataSender");
        this.buffer = new ArrayBuffer(bufferSize);
        this.factory = Objects.requireNonNull(exceptionMetaDataFactory, "exceptionMetaDataFactory");
    }

    @Override
    public void store(List<ExceptionWrapper> wrappers) {
        this.buffer.put((ExceptionWrapper)((Object)wrappers));
        if (this.buffer.isOverflow()) {
            List<ExceptionWrapper> flushData = this.buffer.drain();
            this.sendExceptionMetaData(flushData);
        }
    }

    @Override
    public void flush() {
        List<ExceptionWrapper> copy = this.buffer.drain();
        if (CollectionUtils.hasLength(copy)) {
            this.sendExceptionMetaData(copy);
        }
    }

    @Override
    public void close() {
    }

    private void sendExceptionMetaData(List<ExceptionWrapper> exceptionWrappers) {
        boolean success;
        ExceptionMetaData exceptionMetaData = this.factory.newExceptionMetaData(exceptionWrappers);
        if (isDebug) {
            logger.debug("Flush {}", (Object)exceptionMetaData);
        }
        if (!(success = this.dataSender.request((Object)exceptionMetaData))) {
            logger.debug("send fail");
        }
    }

    public String toString() {
        return "BufferedExceptionStorage{buffer=" + this.buffer + ", dataSender=" + this.dataSender + ", factory=" + this.factory + '}';
    }
}

