/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.profiler.util.TransactionId;
import com.navercorp.pinpoint.common.profiler.util.TransactionIdUtils;
import com.navercorp.pinpoint.profiler.context.id.DefaultTraceId;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.context.module.AgentId;
import com.navercorp.pinpoint.profiler.context.module.AgentStartTime;
import java.util.Objects;

public class DefaultTraceIdFactory
implements TraceIdFactory {
    private final String agentId;
    private final long agentStartTime;

    @Inject
    public DefaultTraceIdFactory(@AgentId String agentId, @AgentStartTime long agentStartTime) {
        this.agentId = Objects.requireNonNull(agentId, "agentId");
        this.agentStartTime = agentStartTime;
    }

    @Override
    public TraceId newTraceId(long localTransactionId) {
        return new DefaultTraceId(this.agentId, this.agentStartTime, localTransactionId);
    }

    @Override
    public TraceId continueTraceId(String transactionId, long parentSpanId, long spanId, short flags) {
        Objects.requireNonNull(transactionId, "transactionId");
        TransactionId parseId = TransactionIdUtils.parseTransactionId((String)transactionId);
        return new DefaultTraceId(parseId.getAgentId(), parseId.getAgentStartTime(), parseId.getTransactionSequence(), parentSpanId, spanId, flags);
    }
}

