/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.module;

import com.google.inject.Key;
import com.google.inject.PrivateModule;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.protobuf.GeneratedMessageV3;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.common.profiler.message.EnhancedDataSender;
import com.navercorp.pinpoint.common.profiler.message.MessageConverter;
import com.navercorp.pinpoint.common.profiler.message.ResultResponse;
import com.navercorp.pinpoint.grpc.client.HeaderFactory;
import com.navercorp.pinpoint.grpc.trace.PSpan;
import com.navercorp.pinpoint.grpc.trace.PSpanChunk;
import com.navercorp.pinpoint.io.ResponseMessage;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.compress.SpanProcessor;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcMessageToResultConverterProvider;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcMetadataMessageConverterProvider;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcSpanMessageConverterProvider;
import com.navercorp.pinpoint.profiler.context.grpc.GrpcStatMessageConverterProvider;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanUriGetter;
import com.navercorp.pinpoint.profiler.context.grpc.config.SpanUriGetterProvider;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentInfoMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentInfoMapperImpl;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentStatMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AgentStatMapperImpl;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.AnnotationValueMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.CustomMetricMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ExceptionMetaDataMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.JvmGcTypeMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.MetaDataMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.SpanMessageMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.SpanMessageMapperImpl;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.ThreadDumpMapper;
import com.navercorp.pinpoint.profiler.context.grpc.mapper.UriStatMapper;
import com.navercorp.pinpoint.profiler.context.module.AgentDataSender;
import com.navercorp.pinpoint.profiler.context.module.GrpcModuleLifeCycle;
import com.navercorp.pinpoint.profiler.context.module.MetadataDataSender;
import com.navercorp.pinpoint.profiler.context.module.ModuleLifeCycle;
import com.navercorp.pinpoint.profiler.context.module.NettyPlatformDependent;
import com.navercorp.pinpoint.profiler.context.module.ResultConverter;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.module.StatDataSender;
import com.navercorp.pinpoint.profiler.context.provider.grpc.AgentGrpcDataSenderProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.AgentHeaderFactoryProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.DnsExecutorServiceProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.GrpcNameResolverProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.GrpcSpanProcessorProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.MetadataGrpcDataSenderProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.ReconnectExecutorProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.ReconnectSchedulerProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.SSLContextProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.SpanGrpcDataSenderProvider;
import com.navercorp.pinpoint.profiler.context.provider.grpc.StatGrpcDataSenderProvider;
import com.navercorp.pinpoint.profiler.metadata.MetaDataType;
import com.navercorp.pinpoint.profiler.monitor.metric.MetricType;
import com.navercorp.pinpoint.profiler.sender.grpc.ReconnectExecutor;
import com.navercorp.pinpoint.profiler.sender.grpc.SubconnectionExpiringLoadBalancerProvider;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzScheduledReporter;
import com.navercorp.pinpoint.profiler.sender.grpc.metric.ChannelzScheduledReporterBuilder;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolverProvider;
import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mapstruct.factory.Mappers;

public class GrpcModule
extends PrivateModule {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ProfilerConfig profilerConfig;
    private final ChannelzScheduledReporter reporter;

    public GrpcModule(ProfilerConfig profilerConfig) {
        this.profilerConfig = Objects.requireNonNull(profilerConfig, "profilerConfig");
        this.reporter = new ChannelzScheduledReporterBuilder().acceptConfig(this.profilerConfig).build();
    }

    protected void configure() {
        this.logger.info("configure {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
        GrpcTransportConfig grpcTransportConfig = this.loadGrpcTransportConfig();
        this.bind(GrpcTransportConfig.class).toInstance((Object)grpcTransportConfig);
        this.bind(ChannelzScheduledReporter.class).toInstance((Object)this.reporter);
        this.bind(ExecutorService.class).toProvider(DnsExecutorServiceProvider.class).in(Scopes.SINGLETON);
        this.bind(NameResolverProvider.class).toProvider(GrpcNameResolverProvider.class).in(Scopes.SINGLETON);
        this.bind(HeaderFactory.class).toProvider(AgentHeaderFactoryProvider.class).in(Scopes.SINGLETON);
        this.bind(ScheduledExecutorService.class).toProvider(ReconnectSchedulerProvider.class).in(Scopes.SINGLETON);
        this.registerGrpcProviders(grpcTransportConfig);
        this.bind(SslContext.class).toProvider(SSLContextProvider.class).in(Scopes.SINGLETON);
        this.bind(ReconnectExecutor.class).toProvider(ReconnectExecutorProvider.class);
        this.bindMappers();
        this.bindAgentDataSender();
        this.bindSpanDataSender();
        this.bindStatDataSender();
        Key rpcModuleLifeCycleKey = Key.get(ModuleLifeCycle.class, (Annotation)Names.named((String)"RPC-MODULE"));
        this.bind(rpcModuleLifeCycleKey).to(GrpcModuleLifeCycle.class).in(Scopes.SINGLETON);
        this.expose(rpcModuleLifeCycleKey);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
        NettyPlatformDependent nettyPlatformDependent = new NettyPlatformDependent(this.profilerConfig, System.getProperties());
        nettyPlatformDependent.setup();
    }

    private void registerGrpcProviders(GrpcTransportConfig grpcTransportConfig) {
        LoadBalancerRegistry.getDefaultRegistry().register((LoadBalancerProvider)new SubconnectionExpiringLoadBalancerProvider(grpcTransportConfig));
    }

    private void bindMappers() {
        this.bind(SpanUriGetter.class).toProvider(SpanUriGetterProvider.class).in(Scopes.SINGLETON);
        this.bind(AnnotationValueMapper.class).toInstance(Mappers.getMapper(AnnotationValueMapper.class));
        this.bind(JvmGcTypeMapper.class).toInstance(Mappers.getMapper(JvmGcTypeMapper.class));
        this.bind(CustomMetricMapper.class).toInstance(Mappers.getMapper(CustomMetricMapper.class));
        this.bind(ExceptionMetaDataMapper.class).toInstance(Mappers.getMapper(ExceptionMetaDataMapper.class));
        this.bind(MetaDataMapper.class).toInstance(Mappers.getMapper(MetaDataMapper.class));
        this.bind(ThreadDumpMapper.class).toInstance(Mappers.getMapper(ThreadDumpMapper.class));
        this.bind(UriStatMapper.class).toInstance(Mappers.getMapper(UriStatMapper.class));
        this.bind(SpanMessageMapper.class).to(SpanMessageMapperImpl.class);
        this.bind(AgentInfoMapper.class).to(AgentInfoMapperImpl.class);
        this.bind(AgentStatMapper.class).to(AgentStatMapperImpl.class);
    }

    private void bindAgentDataSender() {
        TypeLiteral<MessageConverter<MetaDataType, GeneratedMessageV3>> metadataMessageConverter = new TypeLiteral<MessageConverter<MetaDataType, GeneratedMessageV3>>(){};
        Key metadataMessageConverterKey = Key.get((TypeLiteral)metadataMessageConverter, MetadataDataSender.class);
        this.bind(metadataMessageConverterKey).toProvider(GrpcMetadataMessageConverterProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<MessageConverter<Object, ResultResponse>> resultMessageConverter = new TypeLiteral<MessageConverter<Object, ResultResponse>>(){};
        Key resultMessageConverterKey = Key.get((TypeLiteral)resultMessageConverter, ResultConverter.class);
        this.bind(resultMessageConverterKey).toProvider(GrpcMessageToResultConverterProvider.class).in(Scopes.SINGLETON);
        this.expose(resultMessageConverterKey);
        TypeLiteral<EnhancedDataSender<MetaDataType, ResponseMessage>> dataSenderTypeLiteral = new TypeLiteral<EnhancedDataSender<MetaDataType, ResponseMessage>>(){};
        Key agentDataSender = Key.get((TypeLiteral)dataSenderTypeLiteral, AgentDataSender.class);
        this.bind(agentDataSender).toProvider(AgentGrpcDataSenderProvider.class).in(Scopes.SINGLETON);
        this.expose(agentDataSender);
        Key metadataDataSender = Key.get((TypeLiteral)dataSenderTypeLiteral, MetadataDataSender.class);
        this.bind(metadataDataSender).toProvider(MetadataGrpcDataSenderProvider.class).in(Scopes.SINGLETON);
        this.expose(metadataDataSender);
    }

    private void bindStatDataSender() {
        TypeLiteral<MessageConverter<MetricType, GeneratedMessageV3>> statMessageConverter = new TypeLiteral<MessageConverter<MetricType, GeneratedMessageV3>>(){};
        Key statMessageConverterKey = Key.get((TypeLiteral)statMessageConverter, StatDataSender.class);
        this.bind(statMessageConverterKey).toProvider(GrpcStatMessageConverterProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<DataSender<MetricType>> statDataSenderType = new TypeLiteral<DataSender<MetricType>>(){};
        Key statDataSender = Key.get((TypeLiteral)statDataSenderType, StatDataSender.class);
        this.bind(statDataSender).toProvider(StatGrpcDataSenderProvider.class).in(Scopes.SINGLETON);
        this.expose(statDataSender);
    }

    private void bindSpanDataSender() {
        TypeLiteral<MessageConverter<SpanType, GeneratedMessageV3>> protoMessageConverter = new TypeLiteral<MessageConverter<SpanType, GeneratedMessageV3>>(){};
        Key spanMessageConverterKey = Key.get((TypeLiteral)protoMessageConverter, SpanDataSender.class);
        this.bind(spanMessageConverterKey).toProvider(GrpcSpanMessageConverterProvider.class);
        TypeLiteral<SpanProcessor<PSpan.Builder, PSpanChunk.Builder>> spanPostProcessorType = new TypeLiteral<SpanProcessor<PSpan.Builder, PSpanChunk.Builder>>(){};
        this.bind((TypeLiteral)spanPostProcessorType).toProvider(GrpcSpanProcessorProvider.class).in(Scopes.SINGLETON);
        TypeLiteral<DataSender<SpanType>> spanDataSenderType = new TypeLiteral<DataSender<SpanType>>(){};
        Key spanDataSender = Key.get((TypeLiteral)spanDataSenderType, SpanDataSender.class);
        this.bind(spanDataSender).toProvider(SpanGrpcDataSenderProvider.class).in(Scopes.SINGLETON);
        this.expose(spanDataSender);
    }

    private GrpcTransportConfig loadGrpcTransportConfig() {
        GrpcTransportConfig grpcTransportConfig = new GrpcTransportConfig();
        grpcTransportConfig.read(this.profilerConfig.getProperties());
        this.logger.info("{}", (Object)grpcTransportConfig);
        return grpcTransportConfig;
    }
}

