/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.provider;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.common.profiler.message.DataSender;
import com.navercorp.pinpoint.profiler.context.SpanType;
import com.navercorp.pinpoint.profiler.context.config.ContextConfig;
import com.navercorp.pinpoint.profiler.context.module.SpanDataSender;
import com.navercorp.pinpoint.profiler.context.storage.BufferedStorageFactory;
import com.navercorp.pinpoint.profiler.context.storage.StorageFactory;
import com.navercorp.pinpoint.profiler.context.storage.TraceLogDelegateStorage;
import com.navercorp.pinpoint.profiler.context.storage.TraceLogDelegateStorageFactory;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageFactoryProvider
implements Provider<StorageFactory> {
    private final ContextConfig contextConfig;
    private final DataSender<SpanType> spanDataSender;

    @Inject
    public StorageFactoryProvider(ContextConfig contextConfig, @SpanDataSender DataSender<SpanType> spanDataSender) {
        this.contextConfig = Objects.requireNonNull(contextConfig, "profilerConfig");
        this.spanDataSender = Objects.requireNonNull(spanDataSender, "spanDataSender");
    }

    public StorageFactory get() {
        StorageFactory storageFactory = this.newStorageFactory();
        if (this.isTraceLogEnabled()) {
            storageFactory = new TraceLogDelegateStorageFactory(storageFactory);
        }
        return storageFactory;
    }

    private StorageFactory newStorageFactory() {
        if (this.contextConfig.isIoBufferingEnable()) {
            int ioBufferingBufferSize = this.contextConfig.getIoBufferingBufferSize();
            return new BufferedStorageFactory(ioBufferingBufferSize, this.spanDataSender);
        }
        return new BufferedStorageFactory(Integer.MAX_VALUE, this.spanDataSender);
    }

    public String toString() {
        return "StorageFactoryProvider{contextConfig=" + this.contextConfig + ", spanDataSender=" + this.spanDataSender + '}';
    }

    public boolean isTraceLogEnabled() {
        Logger logger = LogManager.getLogger(TraceLogDelegateStorage.class);
        return logger.isTraceEnabled();
    }
}

