/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.Span;
import com.navercorp.pinpoint.profiler.context.SqlCountService;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorder;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorderFactory;
import com.navercorp.pinpoint.profiler.context.id.LocalTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.ChildTraceSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.DefaultSpanRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.DisableChildTraceSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.DisableSpanEventRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.DisableSpanRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.RecorderFactory;
import com.navercorp.pinpoint.profiler.context.recorder.TraceRootSpanRecorder;
import com.navercorp.pinpoint.profiler.context.recorder.WrappedSpanEventRecorder;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import java.util.Objects;

public class DefaultRecorderFactory
implements RecorderFactory {
    private final StringMetaDataService stringMetaDataService;
    private final SqlMetaDataService sqlMetaDataService;
    private final Provider<AsyncContextFactory> asyncContextFactoryProvider;
    private final IgnoreErrorHandler errorHandler;
    private final ExceptionRecorderFactory exceptionRecorderFactory;
    private final SqlCountService sqlCountService;

    @Inject
    public DefaultRecorderFactory(Provider<AsyncContextFactory> asyncContextFactoryProvider, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, IgnoreErrorHandler errorHandler, ExceptionRecorderFactory exceptionRecorderFactory, SqlCountService sqlCountService) {
        this.asyncContextFactoryProvider = Objects.requireNonNull(asyncContextFactoryProvider, "asyncContextFactoryProvider");
        this.stringMetaDataService = Objects.requireNonNull(stringMetaDataService, "stringMetaDataService");
        this.sqlMetaDataService = Objects.requireNonNull(sqlMetaDataService, "sqlMetaDataService");
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        this.exceptionRecorderFactory = Objects.requireNonNull(exceptionRecorderFactory, "exceptionRecorderFactory");
        this.sqlCountService = Objects.requireNonNull(sqlCountService, "sqlCountService");
    }

    @Override
    public SpanRecorder newSpanRecorder(Span span) {
        Objects.requireNonNull(span, "span");
        ExceptionRecorder exceptionRecorder = this.exceptionRecorderFactory.newRecorder(span.getTraceRoot());
        return new DefaultSpanRecorder(span, this.stringMetaDataService, this.sqlMetaDataService, this.errorHandler, exceptionRecorder);
    }

    @Override
    public SpanRecorder newTraceRootSpanRecorder(TraceRoot traceRoot) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        return new TraceRootSpanRecorder(traceRoot);
    }

    @Override
    public SpanRecorder newDisableSpanRecorder(LocalTraceRoot traceRoot) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        return new DisableSpanRecorder(traceRoot, this.errorHandler);
    }

    @Override
    public WrappedSpanEventRecorder newWrappedSpanEventRecorder(TraceRoot traceRoot) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        ExceptionRecorder exceptionRecorder = this.exceptionRecorderFactory.newRecorder(traceRoot);
        return new WrappedSpanEventRecorder(traceRoot, asyncContextFactory, this.stringMetaDataService, this.sqlMetaDataService, this.errorHandler, exceptionRecorder, this.sqlCountService);
    }

    @Override
    public WrappedSpanEventRecorder newWrappedSpanEventRecorder(TraceRoot traceRoot, AsyncState asyncState) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        Objects.requireNonNull(asyncState, "asyncState");
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        ExceptionRecorder exceptionRecorder = this.exceptionRecorderFactory.newRecorder(traceRoot);
        return new WrappedSpanEventRecorder(traceRoot, asyncContextFactory, asyncState, this.stringMetaDataService, this.sqlMetaDataService, this.errorHandler, exceptionRecorder, this.sqlCountService);
    }

    @Override
    public WrappedSpanEventRecorder newChildTraceSpanEventRecorder(TraceRoot traceRoot) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        ExceptionRecorder exceptionRecorder = this.exceptionRecorderFactory.newRecorder(traceRoot);
        return new ChildTraceSpanEventRecorder(traceRoot, asyncContextFactory, this.stringMetaDataService, this.sqlMetaDataService, this.errorHandler, exceptionRecorder, this.sqlCountService);
    }

    @Override
    public DisableSpanEventRecorder newDisableSpanEventRecorder(LocalTraceRoot traceRoot, AsyncState asyncState) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        Objects.requireNonNull(asyncState, "asyncState");
        return this.newDisableSpanEventRecorder0(traceRoot, asyncState);
    }

    @Override
    public DisableSpanEventRecorder newDisableSpanEventRecorder(LocalTraceRoot traceRoot) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        return this.newDisableSpanEventRecorder0(traceRoot, null);
    }

    private DisableSpanEventRecorder newDisableSpanEventRecorder0(LocalTraceRoot traceRoot, AsyncState asyncState) {
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        return new DisableSpanEventRecorder(traceRoot, asyncContextFactory, asyncState);
    }

    @Override
    public DisableSpanEventRecorder newDisableChildTraceSpanEventRecorder(LocalTraceRoot traceRoot, AsyncState asyncState) {
        Objects.requireNonNull(traceRoot, "traceRoot");
        Objects.requireNonNull(asyncState, "asyncState");
        AsyncContextFactory asyncContextFactory = (AsyncContextFactory)this.asyncContextFactoryProvider.get();
        return new DisableChildTraceSpanEventRecorder(traceRoot, asyncContextFactory, asyncState);
    }
}

