/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.recorder;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.AsyncState;
import com.navercorp.pinpoint.bootstrap.context.DatabaseInfo;
import com.navercorp.pinpoint.bootstrap.context.ParsingResult;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.Annotation;
import com.navercorp.pinpoint.profiler.context.AsyncContextFactory;
import com.navercorp.pinpoint.profiler.context.AsyncId;
import com.navercorp.pinpoint.profiler.context.SpanEvent;
import com.navercorp.pinpoint.profiler.context.SpanEventFactory;
import com.navercorp.pinpoint.profiler.context.SqlCountService;
import com.navercorp.pinpoint.profiler.context.errorhandler.IgnoreErrorHandler;
import com.navercorp.pinpoint.profiler.context.exception.ExceptionRecorder;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.recorder.AbstractRecorder;
import com.navercorp.pinpoint.profiler.metadata.SqlMetaDataService;
import com.navercorp.pinpoint.profiler.metadata.StringMetaDataService;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WrappedSpanEventRecorder
extends AbstractRecorder
implements SpanEventRecorder,
AutoCloseable {
    private static final Logger logger = LogManager.getLogger(WrappedSpanEventRecorder.class);
    private static final boolean isDebug = logger.isDebugEnabled();
    private final SqlCountService sqlCountService;
    private final TraceRoot traceRoot;
    private final AsyncContextFactory asyncContextFactory;
    @Nullable
    private final AsyncState asyncState;
    private SpanEvent spanEvent;

    public WrappedSpanEventRecorder(TraceRoot traceRoot, AsyncContextFactory asyncContextFactory, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaDataService, IgnoreErrorHandler ignoreErrorHandler, ExceptionRecorder exceptionRecorder, SqlCountService sqlCountService) {
        this(traceRoot, asyncContextFactory, null, stringMetaDataService, sqlMetaDataService, ignoreErrorHandler, exceptionRecorder, sqlCountService);
    }

    public WrappedSpanEventRecorder(TraceRoot traceRoot, AsyncContextFactory asyncContextFactory, @Nullable AsyncState asyncState, StringMetaDataService stringMetaDataService, SqlMetaDataService sqlMetaCacheService, IgnoreErrorHandler errorHandler, ExceptionRecorder exceptionRecorder, SqlCountService sqlCountService) {
        super(stringMetaDataService, sqlMetaCacheService, errorHandler, exceptionRecorder);
        this.traceRoot = Objects.requireNonNull(traceRoot, "traceRoot");
        this.asyncContextFactory = Objects.requireNonNull(asyncContextFactory, "asyncContextFactory");
        this.asyncState = asyncState;
        this.sqlCountService = Objects.requireNonNull(sqlCountService, "sqlCountService");
    }

    public void setWrapped(SpanEvent spanEvent) {
        this.spanEvent = spanEvent;
    }

    public ParsingResult recordSqlInfo(String sql) {
        if (sql == null) {
            return null;
        }
        ParsingResult parsingResult = this.sqlMetaDataService.wrapSqlResult(sql);
        this.recordSqlParsingResult(parsingResult);
        return parsingResult;
    }

    public void recordSqlParsingResult(ParsingResult parsingResult) {
        this.recordSqlParsingResult(parsingResult, null);
    }

    public void recordSqlParsingResult(ParsingResult parsingResult, String bindValue) {
        if (parsingResult == null) {
            return;
        }
        Annotation<?> sqlAnnotation = this.sqlMetaDataService.newSqlAnnotation(parsingResult, bindValue);
        this.spanEvent.addAnnotation(sqlAnnotation);
        if (this.spanEvent.isExecuteQueryType()) {
            this.sqlCountService.recordSqlCount(this.traceRoot);
        }
    }

    public void recordDatabaseInfo(DatabaseInfo databaseInfo, boolean executeQueryType) {
        this.spanEvent.setExecuteQueryType(executeQueryType);
        this.recordServiceType(executeQueryType ? databaseInfo.getExecuteQueryType() : databaseInfo.getType());
        this.recordEndPoint(databaseInfo.getMultipleHost());
        this.recordDestinationId(databaseInfo.getDatabaseId());
    }

    public void recordDestinationId(String destinationId) {
        this.spanEvent.setDestinationId(destinationId);
    }

    public void recordNextSpanId(long nextSpanId) {
        if (nextSpanId == -1L) {
            return;
        }
        this.spanEvent.setNextSpanId(nextSpanId);
    }

    public AsyncContext recordNextAsyncContext() {
        TraceRoot traceRoot = this.traceRoot;
        AsyncId asyncIdObject = this.getNextAsyncId();
        boolean canSampled = this.isOverflowState();
        return this.asyncContextFactory.newAsyncContext(traceRoot, asyncIdObject, canSampled);
    }

    protected boolean isOverflowState() {
        return !SpanEventFactory.isDisableSpanEvent(this.spanEvent);
    }

    public AsyncContext recordNextAsyncContext(boolean asyncStateSupport) {
        if (asyncStateSupport && this.asyncState != null) {
            AsyncId asyncIdObject = this.getNextAsyncId();
            boolean isDisabled = this.isOverflowState();
            AsyncState asyncState = this.asyncState;
            asyncState.setup();
            return this.asyncContextFactory.newAsyncContext(this.traceRoot, asyncIdObject, isDisabled, asyncState);
        }
        return this.recordNextAsyncContext();
    }

    @Override
    void maskErrorCode(int errorCode) {
        this.traceRoot.getShared().maskErrorCode(errorCode);
    }

    @Override
    void setExceptionInfo(int exceptionClassId, String exceptionMessage) {
        this.spanEvent.setExceptionInfo(exceptionClassId, exceptionMessage);
    }

    @Override
    void recordDetailedException(Throwable throwable) {
        this.exceptionRecorder.recordException(this.spanEvent, throwable);
    }

    public void recordApiId(int apiId) {
        this.setApiId0(apiId);
    }

    @Override
    void setApiId0(int apiId) {
        this.spanEvent.setApiId(apiId);
    }

    @Override
    void addAnnotation(Annotation<?> annotation) {
        this.spanEvent.addAnnotation(annotation);
    }

    public void recordServiceType(ServiceType serviceType) {
        this.spanEvent.setServiceType(serviceType.getCode());
    }

    public void recordEndPoint(String endPoint) {
        this.spanEvent.setEndPoint(endPoint);
    }

    public void recordTime(boolean time) {
        this.spanEvent.setTimeRecording(time);
        if (time) {
            if (this.spanEvent.getStartTime() != 0L) {
                this.spanEvent.markStartTime();
            }
        } else {
            this.spanEvent.setStartTime(0L);
            this.spanEvent.setElapsedTime(0);
        }
    }

    public Object detachFrameObject() {
        return this.spanEvent.detachFrameObject();
    }

    public Object getFrameObject() {
        return this.spanEvent.getFrameObject();
    }

    public Object attachFrameObject(Object frameObject) {
        return this.spanEvent.attachFrameObject(frameObject);
    }

    protected AsyncId getNextAsyncId() {
        AsyncId nextAsyncId = this.spanEvent.getAsyncIdObject();
        if (nextAsyncId == null) {
            nextAsyncId = this.asyncContextFactory.newAsyncId();
            this.spanEvent.setAsyncIdObject(nextAsyncId);
        }
        return nextAsyncId;
    }

    @Override
    public void close() {
        this.exceptionRecorder.close();
    }
}

