/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.ASMifier;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMBytecodeDisassembler {
    private final int cwFlag;
    private final int crFlag;

    public ASMBytecodeDisassembler() {
        this(0, 0);
    }

    public ASMBytecodeDisassembler(int crFlag, int cwFlag) {
        this.cwFlag = cwFlag;
        this.crFlag = crFlag;
    }

    public String dumpBytecode(byte[] bytecode) {
        Objects.requireNonNull(bytecode, "bytecode");
        return this.writeBytecode(bytecode, (Printer)new Textifier());
    }

    public String dumpASM(byte[] bytecode) {
        Objects.requireNonNull(bytecode, "bytecode");
        return this.writeBytecode(bytecode, (Printer)new ASMifier());
    }

    private String writeBytecode(byte[] bytecode, Printer printer) {
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        this.accept(bytecode, printer, writer);
        return out.toString();
    }

    private void accept(byte[] bytecode, Printer printer, PrintWriter writer) {
        ClassReader cr = new ClassReader(bytecode);
        ClassWriter cw = new ClassWriter(this.cwFlag);
        TraceClassVisitor tcv = new TraceClassVisitor((ClassVisitor)cw, printer, writer);
        cr.accept((ClassVisitor)tcv, this.crFlag);
    }

    public String dumpVerify(byte[] bytecode, ClassLoader classLoader) {
        Objects.requireNonNull(bytecode, "bytecode");
        Objects.requireNonNull(classLoader, "classLoader");
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        ClassReader cr = new ClassReader(bytecode);
        CheckClassAdapter.verify((ClassReader)cr, (ClassLoader)classLoader, (boolean)true, (PrintWriter)writer);
        return out.toString();
    }
}

