/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument;

import com.navercorp.pinpoint.bootstrap.instrument.ClassInputStreamProvider;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.NotFoundInstrumentException;
import com.navercorp.pinpoint.profiler.instrument.ASMClass;
import com.navercorp.pinpoint.profiler.instrument.ASMClassNodeAdapter;
import com.navercorp.pinpoint.profiler.instrument.EngineComponent;
import com.navercorp.pinpoint.profiler.instrument.InstrumentEngine;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Objects;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class ASMEngine
implements InstrumentEngine {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final boolean isInfo = this.logger.isInfoEnabled();
    private final Instrumentation instrumentation;
    private final EngineComponent engineComponent;

    public ASMEngine(Instrumentation instrumentation, EngineComponent engineComponent) {
        this.instrumentation = Objects.requireNonNull(instrumentation, "instrumentation");
        this.engineComponent = Objects.requireNonNull(engineComponent, "engineComponent");
    }

    @Override
    public InstrumentClass getClass(InstrumentContext instrumentContext, ClassLoader classLoader, String className, ProtectionDomain protectionDomain, byte[] classFileBuffer) throws NotFoundInstrumentException {
        Objects.requireNonNull(className, "className");
        try {
            if (classFileBuffer == null) {
                ASMClassNodeAdapter classNode = ASMClassNodeAdapter.get((ClassInputStreamProvider)instrumentContext, classLoader, protectionDomain, JavaAssistUtils.javaNameToJvmName(className));
                if (classNode == null) {
                    return null;
                }
                return new ASMClass(this.engineComponent, instrumentContext, classNode);
            }
            ClassReader classReader = new ClassReader(classFileBuffer);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 0);
            return ASMClass.load(this.engineComponent, instrumentContext, classLoader, protectionDomain, classNode);
        }
        catch (Exception e) {
            throw new NotFoundInstrumentException((Throwable)e);
        }
    }

    @Override
    public void appendToBootstrapClassPath(JarFile jarFile) {
        Objects.requireNonNull(jarFile, "jarFile");
        if (this.isInfo) {
            this.logger.info("appendToBootstrapClassPath:{}", (Object)jarFile.getName());
        }
        this.instrumentation.appendToBootstrapClassLoaderSearch(jarFile);
    }
}

