/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.monitor;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import com.navercorp.pinpoint.common.util.ThreadMXBeanUtils;
import com.navercorp.pinpoint.profiler.monitor.DeadlockThreadRegistry;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeadlockMonitorTask
implements Runnable {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final DeadlockThreadRegistry deadlockThreadRegistry;
    private final long intervalMillis;
    private final AtomicBoolean stop = new AtomicBoolean(false);

    public DeadlockMonitorTask(DeadlockThreadRegistry deadlockThreadRegistry, long intervalMillis) {
        this.deadlockThreadRegistry = deadlockThreadRegistry;
        this.intervalMillis = intervalMillis;
    }

    @Override
    public void run() {
        while (!this.stop.get()) {
            this.doTask();
            this.waitNextTask();
        }
        this.logger.info("DeadlockMonitorTask stop completed");
    }

    void doTask() {
        long[] deadlockedThreadIds = ThreadMXBeanUtils.findDeadlockedThreads();
        if (ArrayUtils.isEmpty((long[])deadlockedThreadIds)) {
            return;
        }
        boolean foundNewDeadlockedThread = false;
        for (long deadlockedThreadId : deadlockedThreadIds) {
            boolean added = this.deadlockThreadRegistry.addDeadlockedThread(deadlockedThreadId);
            if (!added) continue;
            foundNewDeadlockedThread = true;
        }
        if (foundNewDeadlockedThread) {
            StringBuilder deadlockOutput = new StringBuilder();
            deadlockOutput.append(LINE_SEPARATOR);
            deadlockOutput.append("================================================================").append(LINE_SEPARATOR);
            deadlockOutput.append("[PINPOINT] Found one Java-level deadlock:").append(LINE_SEPARATOR);
            deadlockOutput.append(LINE_SEPARATOR);
            deadlockOutput.append("If pinpoints affect the deadlock below, please put all the information posted on pinpoint's github.").append(LINE_SEPARATOR);
            deadlockOutput.append("(https://github.com/naver/pinpoint/issues)").append(LINE_SEPARATOR);
            deadlockOutput.append("================================================================").append(LINE_SEPARATOR);
            for (long deadlockedThreadId : deadlockedThreadIds) {
                ThreadInfo threadInfo = ThreadMXBeanUtils.getThreadInfo((long)deadlockedThreadId);
                deadlockOutput.append(this.createThreadDump(threadInfo));
            }
            deadlockOutput.append("================================================================").append(LINE_SEPARATOR);
            this.logger.warn(deadlockOutput.toString());
        }
    }

    private String createThreadDump(ThreadInfo threadInfo) {
        StringBuilder sb = new StringBuilder("\"" + threadInfo.getThreadName() + "\" Id=" + threadInfo.getThreadId() + " " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            sb.append(" on " + threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"" + threadInfo.getLockOwnerName() + "\" Id=" + threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            MonitorInfo[] lockedMonitors;
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && threadInfo.getLockInfo() != null) {
                LockInfo lockInfo = threadInfo.getLockInfo();
                Thread.State ts = threadInfo.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + lockInfo);
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + lockInfo);
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + lockInfo);
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (MonitorInfo mi : lockedMonitors = threadInfo.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + mi);
                sb.append('\n');
            }
        }
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- " + li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    private void waitNextTask() {
        if (!Thread.interrupted()) {
            try {
                Thread.sleep(this.intervalMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    void stop() {
        if (this.stop.compareAndSet(false, true)) {
            this.logger.info("DeadlockMonitorTask stop started");
        } else {
            this.logger.info("DeadlockMonitorTask already stopped");
        }
    }
}

