/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.Name;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.NoCache;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.bootstrap.plugin.RequestRecorderFactory;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitorRegistry;
import com.navercorp.pinpoint.bootstrap.plugin.monitor.metric.CustomMetricRegistry;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.metadata.ApiMetaDataService;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.Option;
import com.navercorp.pinpoint.profiler.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.util.Objects;

public class InterceptorArgumentProvider
implements ArgumentProvider {
    private final DataSourceMonitorRegistry dataSourceMonitorRegistry;
    private final CustomMetricRegistry customMetricRegistry;
    private final ApiMetaDataService apiMetaDataService;
    private final InterceptorScope interceptorScope;
    private final MethodDescriptor methodDescriptor;
    private final RequestRecorderFactory requestRecorderFactory;

    public InterceptorArgumentProvider(DataSourceMonitorRegistry dataSourceMonitorRegistry, CustomMetricRegistry customMetricRegistry, ApiMetaDataService apiMetaDataService, RequestRecorderFactory requestRecorderFactory) {
        this(dataSourceMonitorRegistry, customMetricRegistry, apiMetaDataService, requestRecorderFactory, null, null);
    }

    public InterceptorArgumentProvider(DataSourceMonitorRegistry dataSourceMonitorRegistry, CustomMetricRegistry customMetricRegistry, ApiMetaDataService apiMetaDataService, RequestRecorderFactory requestRecorderFactory, InterceptorScope interceptorScope, MethodDescriptor methodDescriptor) {
        this.dataSourceMonitorRegistry = Objects.requireNonNull(dataSourceMonitorRegistry, "dataSourceMonitorRegistry");
        this.customMetricRegistry = Objects.requireNonNull(customMetricRegistry, "customMetricRegistry");
        this.apiMetaDataService = Objects.requireNonNull(apiMetaDataService, "apiMetaDataService");
        this.requestRecorderFactory = requestRecorderFactory;
        this.interceptorScope = interceptorScope;
        this.methodDescriptor = methodDescriptor;
    }

    @Override
    public Option get(int index, Class<?> type, Annotation[] annotations) {
        if (type == MethodDescriptor.class) {
            if (this.methodDescriptor != null) {
                this.cacheApiIfAnnotationNotPresent(annotations, this.methodDescriptor);
            }
            return Option.withValue(this.methodDescriptor);
        }
        if (type == InterceptorScope.class) {
            Name annotation = TypeUtils.findAnnotation(annotations, Name.class);
            if (annotation == null) {
                if (this.interceptorScope == null) {
                    throw new PinpointException("Scope parameter is not annotated with @Name and the target class is not associated with any Scope");
                }
                return Option.withValue(this.interceptorScope);
            }
            return Option.empty();
        }
        if (type == DataSourceMonitorRegistry.class) {
            return Option.withValue(this.dataSourceMonitorRegistry);
        }
        if (type == RequestRecorderFactory.class) {
            return Option.withValue(this.requestRecorderFactory);
        }
        if (type == CustomMetricRegistry.class) {
            return Option.withValue(this.customMetricRegistry);
        }
        return Option.empty();
    }

    private void cacheApiIfAnnotationNotPresent(Annotation[] annotations, MethodDescriptor descriptor) {
        NoCache annotation = TypeUtils.findAnnotation(annotations, NoCache.class);
        if (annotation == null) {
            this.apiMetaDataService.cacheApi(descriptor);
        }
    }
}

