/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.plugin;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.plugin.TransformCallbackProvider;
import java.lang.reflect.Constructor;
import java.util.Objects;

public class DynamicTransformCallbackProvider
implements TransformCallbackProvider {
    private final String transformCallbackClassName;
    private final Object[] parameters;
    private final Class<?>[] parameterTypes;

    public DynamicTransformCallbackProvider(String transformCallbackClassName) {
        this.transformCallbackClassName = Objects.requireNonNull(transformCallbackClassName, "transformCallbackClassName");
        this.parameters = null;
        this.parameterTypes = null;
    }

    public DynamicTransformCallbackProvider(String transformCallbackClassName, Object[] parameters, Class<?>[] parameterTypes) {
        this.transformCallbackClassName = Objects.requireNonNull(transformCallbackClassName, "transformCallbackClassName");
        this.parameters = parameters;
        this.parameterTypes = parameterTypes;
    }

    @Override
    public TransformCallback getTransformCallback(InstrumentContext instrumentContext, ClassLoader loader) {
        try {
            Class transformCallbackClass = instrumentContext.injectClass(loader, this.transformCallbackClassName);
            Constructor constructor = transformCallbackClass.getConstructor(this.parameterTypes);
            return (TransformCallback)constructor.newInstance(this.parameters);
        }
        catch (ReflectiveOperationException e) {
            throw new PinpointException(this.transformCallbackClassName + " load fail Caused by:" + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return "DynamicTransformCallbackProvider{transformCallbackClassName='" + this.transformCallbackClassName + '\'' + '}';
    }
}

