/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.sampler;

import com.navercorp.pinpoint.bootstrap.sampler.Sampler;
import com.navercorp.pinpoint.bootstrap.sampler.TraceSampler;
import com.navercorp.pinpoint.profiler.context.id.IdGenerator;
import java.util.Objects;

public class BasicTraceSampler
implements TraceSampler {
    private final Sampler sampler;
    private final TraceSampler.State newSuccessState;
    private final TraceSampler.State newDisableState;
    private final TraceSampler.State continueSuccessState;
    private final TraceSampler.State continueDisableState;

    public BasicTraceSampler(final IdGenerator idGenerator, Sampler sampler) {
        Objects.requireNonNull(idGenerator, "idGenerator");
        this.sampler = Objects.requireNonNull(sampler, "sampler");
        this.newSuccessState = new TraceSampler.State(){

            public boolean isSampled() {
                return true;
            }

            public long nextId() {
                return idGenerator.nextTransactionId();
            }
        };
        this.newDisableState = new TraceSampler.State(){

            public boolean isSampled() {
                return false;
            }

            public long nextId() {
                return idGenerator.nextDisabledId();
            }
        };
        this.continueSuccessState = new TraceSampler.State(){

            public boolean isSampled() {
                return true;
            }

            public long nextId() {
                return idGenerator.nextContinuedTransactionId();
            }
        };
        this.continueDisableState = new TraceSampler.State(){

            public boolean isSampled() {
                return false;
            }

            public long nextId() {
                return idGenerator.nextContinuedDisabledId();
            }
        };
    }

    public TraceSampler.State isNewSampled() {
        if (this.sampler.isSampling()) {
            return this.newSuccessState;
        }
        return this.newDisableState;
    }

    public TraceSampler.State isNewSampled(String urlPath) {
        return this.isNewSampled();
    }

    public TraceSampler.State isContinueSampled() {
        return this.continueSuccessState;
    }

    public TraceSampler.State getContinueDisableState() {
        return this.continueDisableState;
    }
}

