/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.transformer;

import com.navercorp.pinpoint.profiler.instrument.transformer.LambdaClassFileResolver;
import com.navercorp.pinpoint.profiler.instrument.transformer.TransformerRegistry;
import com.navercorp.pinpoint.profiler.transformer.BaseClassFileTransformer;
import com.navercorp.pinpoint.profiler.transformer.ClassFileFilter;
import com.navercorp.pinpoint.profiler.transformer.ClassFileTransformerDispatcher;
import com.navercorp.pinpoint.profiler.transformer.DynamicTransformerRegistry;
import com.navercorp.pinpoint.profiler.transformer.PinpointClassLoaderFilter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Objects;

public class DefaultClassFileTransformerDispatcher
implements ClassFileTransformerDispatcher {
    private final BaseClassFileTransformer baseClassFileTransformer = new BaseClassFileTransformer(this.getClass().getClassLoader());
    private final TransformerRegistry transformerRegistry;
    private final DynamicTransformerRegistry dynamicTransformerRegistry;
    private final ClassFileFilter classLoaderFilter = new PinpointClassLoaderFilter(this.getClass().getClassLoader());
    private final ClassFileFilter pinpointClassFilter;
    private final ClassFileFilter unmodifiableFilter;
    private final LambdaClassFileResolver lambdaClassFileResolver;

    public DefaultClassFileTransformerDispatcher(ClassFileFilter pinpointClassFilter, ClassFileFilter unmodifiableFilter, TransformerRegistry transformerRegistry, DynamicTransformerRegistry dynamicTransformerRegistry, LambdaClassFileResolver lambdaClassFileResolver) {
        this.pinpointClassFilter = Objects.requireNonNull(pinpointClassFilter, "pinpointClassFilter");
        this.unmodifiableFilter = Objects.requireNonNull(unmodifiableFilter, "unmodifiableFilter");
        this.transformerRegistry = Objects.requireNonNull(transformerRegistry, "transformerRegistry");
        this.dynamicTransformerRegistry = Objects.requireNonNull(dynamicTransformerRegistry, "dynamicTransformerRegistry");
        this.lambdaClassFileResolver = Objects.requireNonNull(lambdaClassFileResolver, "lambdaClassFileResolver");
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String classInternalName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) throws IllegalClassFormatException {
        if (!this.classLoaderFilter.accept(classLoader, classInternalName, classBeingRedefined, protectionDomain, classFileBuffer)) {
            return null;
        }
        String internalName = this.lambdaClassFileResolver.resolve(classLoader, classInternalName, protectionDomain, classFileBuffer);
        if (internalName == null) {
            return null;
        }
        if (!this.pinpointClassFilter.accept(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer)) {
            return null;
        }
        ClassFileTransformer dynamicTransformer = this.dynamicTransformerRegistry.getTransformer(classLoader, internalName);
        if (dynamicTransformer != null) {
            return this.baseClassFileTransformer.transform(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer, dynamicTransformer);
        }
        if (!this.unmodifiableFilter.accept(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer)) {
            return null;
        }
        ClassFileTransformer transformer = this.transformerRegistry.findTransformer(classLoader, internalName, classFileBuffer);
        if (transformer == null) {
            return null;
        }
        return this.baseClassFileTransformer.transform(classLoader, internalName, classBeingRedefined, protectionDomain, classFileBuffer, transformer);
    }
}

