/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.protocol;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SecurityUtil {
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Map<Character, Integer> rDigits = new HashMap<Character, Integer>(16);

    public static String md5String(String content) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("md5");
        byte[] bt = md.digest(content.getBytes());
        if (null == bt || bt.length != 16) {
            throw new IllegalArgumentException("md5 need");
        }
        return SecurityUtil.byte2HexStr(bt);
    }

    public static final String scrambleGenPass(byte[] pass) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] pass1 = md.digest(pass);
        md.reset();
        byte[] pass2 = md.digest(pass1);
        return SecurityUtil.byte2HexStr(pass2);
    }

    public static final boolean scrambleServerAuth(byte[] token, byte[] pass, byte[] seed) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(seed);
        byte[] pass1 = md.digest(pass);
        for (int i = 0; i < pass1.length; ++i) {
            pass1[i] = (byte)(token[i] ^ pass1[i]);
        }
        md = MessageDigest.getInstance("SHA-1");
        byte[] pass2 = md.digest(pass1);
        return Arrays.equals(pass, pass2);
    }

    public static final byte[] scramble411(byte[] pass, byte[] seed) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] pass1 = md.digest(pass);
        md.reset();
        byte[] pass2 = md.digest(pass1);
        md.reset();
        md.update(seed);
        byte[] pass3 = md.digest(pass2);
        for (int i = 0; i < pass3.length; ++i) {
            pass3[i] = (byte)(pass3[i] ^ pass1[i]);
        }
        return pass3;
    }

    public static String byte2HexStr(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (byte value : b) {
            String hex = Integer.toHexString(value & 0xFF);
            if (hex.length() == 1) {
                hs.append("0" + hex);
                continue;
            }
            hs.append(hex);
        }
        return hs.toString();
    }

    public static byte[] hexStr2Bytes(String src) {
        if (src == null) {
            return null;
        }
        int offset = 0;
        int length = src.length();
        if (length == 0) {
            return new byte[0];
        }
        boolean odd = length << 31 == Integer.MIN_VALUE;
        byte[] bs = new byte[odd ? length + 1 >> 1 : length >> 1];
        int limit = offset + length;
        for (int i = offset; i < limit; ++i) {
            int b;
            char low;
            int high;
            if (i == offset && odd) {
                high = 48;
                low = src.charAt(i);
            } else {
                high = src.charAt(i);
                low = src.charAt(++i);
            }
            switch (high) {
                case 48: {
                    b = 0;
                    break;
                }
                case 49: {
                    b = 16;
                    break;
                }
                case 50: {
                    b = 32;
                    break;
                }
                case 51: {
                    b = 48;
                    break;
                }
                case 52: {
                    b = 64;
                    break;
                }
                case 53: {
                    b = 80;
                    break;
                }
                case 54: {
                    b = 96;
                    break;
                }
                case 55: {
                    b = 112;
                    break;
                }
                case 56: {
                    b = 128;
                    break;
                }
                case 57: {
                    b = 144;
                    break;
                }
                case 65: 
                case 97: {
                    b = 160;
                    break;
                }
                case 66: 
                case 98: {
                    b = 176;
                    break;
                }
                case 67: 
                case 99: {
                    b = 192;
                    break;
                }
                case 68: 
                case 100: {
                    b = 208;
                    break;
                }
                case 69: 
                case 101: {
                    b = 224;
                    break;
                }
                case 70: 
                case 102: {
                    b = 240;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal hex-string: " + src);
                }
            }
            switch (low) {
                case '0': {
                    break;
                }
                case '1': {
                    ++b;
                    break;
                }
                case '2': {
                    b += 2;
                    break;
                }
                case '3': {
                    b += 3;
                    break;
                }
                case '4': {
                    b += 4;
                    break;
                }
                case '5': {
                    b += 5;
                    break;
                }
                case '6': {
                    b += 6;
                    break;
                }
                case '7': {
                    b += 7;
                    break;
                }
                case '8': {
                    b += 8;
                    break;
                }
                case '9': {
                    b += 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    b += 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    b += 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    b += 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    b += 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    b += 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    b += 15;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal hex-string: " + src);
                }
            }
            bs[i - offset >> 1] = (byte)b;
        }
        return bs;
    }

    static {
        for (int i = 0; i < digits.length; ++i) {
            rDigits.put(Character.valueOf(digits[i]), i);
        }
    }
}

