/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.LogBuffer;
import com.taobao.tddl.dbsync.binlog.LogEvent;
import com.taobao.tddl.dbsync.binlog.event.FormatDescriptionLogEvent;
import com.taobao.tddl.dbsync.binlog.event.LogHeader;

public class TransactionPayloadLogEvent
extends LogEvent {
    public static final short COMPRESSION_TYPE_MIN_LENGTH = 1;
    public static final short COMPRESSION_TYPE_MAX_LENGTH = 9;
    public static final short PAYLOAD_SIZE_MIN_LENGTH = 0;
    public static final short PAYLOAD_SIZE_MAX_LENGTH = 9;
    public static final short UNCOMPRESSED_SIZE_MIN_LENGTH = 0;
    public static final short UNCOMPRESSED_SIZE_MAX_LENGTH = 9;
    public static final int MAX_DATA_LENGTH = 27;
    public static final int OTW_PAYLOAD_HEADER_END_MARK = 0;
    public static final int OTW_PAYLOAD_SIZE_FIELD = 1;
    public static final int OTW_PAYLOAD_COMPRESSION_TYPE_FIELD = 2;
    public static final int OTW_PAYLOAD_UNCOMPRESSED_SIZE_FIELD = 3;
    public static final int COMPRESS_TYPE_ZSTD = 0;
    public static final int COMPRESS_TYPE_NONE = 255;
    private long m_compression_type = 255L;
    private long m_payload_size;
    private long m_uncompressed_size;
    private byte[] m_payload;

    public TransactionPayloadLogEvent(LogHeader header, LogBuffer buffer, FormatDescriptionLogEvent descriptionEvent) {
        super(header);
        int commonHeaderLen = descriptionEvent.getCommonHeaderLen();
        short postHeaderLen = descriptionEvent.getPostHeaderLen()[header.getType() - 1];
        int offset = commonHeaderLen;
        buffer.position(offset);
        long type = 0L;
        long length = 0L;
        block5: while (buffer.hasRemaining() && (type = buffer.getPackedLong()) != 0L) {
            length = buffer.getPackedLong();
            switch ((int)type) {
                case 1: {
                    this.m_payload_size = buffer.getPackedLong();
                    continue block5;
                }
                case 2: {
                    this.m_compression_type = buffer.getPackedLong();
                    continue block5;
                }
                case 3: {
                    this.m_uncompressed_size = buffer.getPackedLong();
                    continue block5;
                }
            }
            buffer.forward((int)length);
        }
        if (this.m_uncompressed_size == 0L) {
            this.m_uncompressed_size = this.m_payload_size;
        }
        this.m_payload = buffer.getData((int)this.m_payload_size);
    }

    public boolean isCompressByZstd() {
        return this.m_compression_type == 0L;
    }

    public boolean isCompressByNone() {
        return this.m_compression_type == 255L;
    }

    public byte[] getPayload() {
        return this.m_payload;
    }
}

