/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.EventMeshDateFormat;
import org.apache.eventmesh.common.exception.JsonException;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)OBJECT_MAPPER.convertValue(fromValue, toValueType);
    }

    public static <T> T convertValue(Object fromValue, TypeReference<T> toValueTypeRef) {
        return (T)OBJECT_MAPPER.convertValue(fromValue, toValueTypeRef);
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> beanClass) {
        if (map == null) {
            return null;
        }
        Object obj = OBJECT_MAPPER.convertValue(map, beanClass);
        return beanClass.cast(obj);
    }

    public static Map<String, Object> objectToMap(Object obj) {
        if (obj == null) {
            return null;
        }
        return (Map)OBJECT_MAPPER.convertValue(obj, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static String toJSONString(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("serialize to json error", e);
        }
    }

    public static byte[] toJSONBytes(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("serialize to json error", e);
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(text, clazz);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to object error", e);
        }
    }

    public static <T> T parseObject(InputStream inputStream, Class<T> clazz) {
        try {
            return (T)OBJECT_MAPPER.readValue(inputStream, clazz);
        }
        catch (IOException e) {
            throw new JsonException("deserialize input stream to object error", e);
        }
    }

    public static <T> T parseObject(String text, final Type type) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            TypeReference typeReference = new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            };
            return (T)OBJECT_MAPPER.readValue(text, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to object error", e);
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(bytes, clazz);
        }
        catch (IOException e) {
            throw new JsonException(String.format("parse bytes to %s error", clazz), e);
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(text, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to object error", e);
        }
    }

    public static <T> T parseTypeReferenceObject(String text, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return (T)OBJECT_MAPPER.readValue(text, typeReference);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to typeReference error", e);
        }
    }

    public static <T> T parseTypeReferenceObject(Object object, TypeReference<T> typeReference) {
        if (object == null) {
            return null;
        }
        return JsonUtils.convertValue(object, typeReference);
    }

    public static <T> T parseTypeReferenceObject(byte[] text, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(text, typeReference);
        }
        catch (IOException e) {
            throw new JsonException("deserialize json string to typeReference error", e);
        }
    }

    public static JsonNode getJsonNode(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return null;
        }
        try {
            return OBJECT_MAPPER.readTree(text);
        }
        catch (JsonProcessingException e) {
            throw new JsonException("deserialize json string to JsonNode error", e);
        }
    }

    static {
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        OBJECT_MAPPER.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        OBJECT_MAPPER.setDateFormat((DateFormat)new EventMeshDateFormat("yyyy-MM-dd HH:mm:ss"));
        OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

