/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import org.rocksdb.Env;
import org.rocksdb.Logger;
import org.rocksdb.RateLimiter;
import org.rocksdb.RocksObject;

public class BackupEngineOptions
extends RocksObject {
    private Env backupEnv = null;
    private Logger infoLog = null;
    private RateLimiter backupRateLimiter = null;
    private RateLimiter restoreRateLimiter = null;

    public BackupEngineOptions(String string) {
        super(BackupEngineOptions.newBackupEngineOptions(BackupEngineOptions.ensureWritableFile(string)));
    }

    private static String ensureWritableFile(String string) {
        File file;
        File file2 = file = string == null ? null : new File(string);
        if (file == null || !file.isDirectory() || !file.canWrite()) {
            throw new IllegalArgumentException("Illegal path provided.");
        }
        return string;
    }

    public String backupDir() {
        assert (this.isOwningHandle());
        return this.backupDir(this.nativeHandle_);
    }

    public BackupEngineOptions setBackupEnv(Env env) {
        assert (this.isOwningHandle());
        this.setBackupEnv(this.nativeHandle_, env.nativeHandle_);
        this.backupEnv = env;
        return this;
    }

    public Env backupEnv() {
        return this.backupEnv;
    }

    public BackupEngineOptions setShareTableFiles(boolean bl) {
        assert (this.isOwningHandle());
        this.setShareTableFiles(this.nativeHandle_, bl);
        return this;
    }

    public boolean shareTableFiles() {
        assert (this.isOwningHandle());
        return this.shareTableFiles(this.nativeHandle_);
    }

    public BackupEngineOptions setInfoLog(Logger logger) {
        assert (this.isOwningHandle());
        this.setInfoLog(this.nativeHandle_, logger.nativeHandle_);
        this.infoLog = logger;
        return this;
    }

    public Logger infoLog() {
        return this.infoLog;
    }

    public BackupEngineOptions setSync(boolean bl) {
        assert (this.isOwningHandle());
        this.setSync(this.nativeHandle_, bl);
        return this;
    }

    public boolean sync() {
        assert (this.isOwningHandle());
        return this.sync(this.nativeHandle_);
    }

    public BackupEngineOptions setDestroyOldData(boolean bl) {
        assert (this.isOwningHandle());
        this.setDestroyOldData(this.nativeHandle_, bl);
        return this;
    }

    public boolean destroyOldData() {
        assert (this.isOwningHandle());
        return this.destroyOldData(this.nativeHandle_);
    }

    public BackupEngineOptions setBackupLogFiles(boolean bl) {
        assert (this.isOwningHandle());
        this.setBackupLogFiles(this.nativeHandle_, bl);
        return this;
    }

    public boolean backupLogFiles() {
        assert (this.isOwningHandle());
        return this.backupLogFiles(this.nativeHandle_);
    }

    public BackupEngineOptions setBackupRateLimit(long l) {
        assert (this.isOwningHandle());
        this.setBackupRateLimit(this.nativeHandle_, l <= 0L ? 0L : l);
        return this;
    }

    public long backupRateLimit() {
        assert (this.isOwningHandle());
        return this.backupRateLimit(this.nativeHandle_);
    }

    public BackupEngineOptions setBackupRateLimiter(RateLimiter rateLimiter) {
        assert (this.isOwningHandle());
        this.setBackupRateLimiter(this.nativeHandle_, rateLimiter.nativeHandle_);
        this.backupRateLimiter = rateLimiter;
        return this;
    }

    public RateLimiter backupRateLimiter() {
        assert (this.isOwningHandle());
        return this.backupRateLimiter;
    }

    public BackupEngineOptions setRestoreRateLimit(long l) {
        assert (this.isOwningHandle());
        this.setRestoreRateLimit(this.nativeHandle_, l <= 0L ? 0L : l);
        return this;
    }

    public long restoreRateLimit() {
        assert (this.isOwningHandle());
        return this.restoreRateLimit(this.nativeHandle_);
    }

    public BackupEngineOptions setRestoreRateLimiter(RateLimiter rateLimiter) {
        assert (this.isOwningHandle());
        this.setRestoreRateLimiter(this.nativeHandle_, rateLimiter.nativeHandle_);
        this.restoreRateLimiter = rateLimiter;
        return this;
    }

    public RateLimiter restoreRateLimiter() {
        assert (this.isOwningHandle());
        return this.restoreRateLimiter;
    }

    public BackupEngineOptions setShareFilesWithChecksum(boolean bl) {
        assert (this.isOwningHandle());
        this.setShareFilesWithChecksum(this.nativeHandle_, bl);
        return this;
    }

    public boolean shareFilesWithChecksum() {
        assert (this.isOwningHandle());
        return this.shareFilesWithChecksum(this.nativeHandle_);
    }

    public BackupEngineOptions setMaxBackgroundOperations(int n) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundOperations(this.nativeHandle_, n);
        return this;
    }

    public int maxBackgroundOperations() {
        assert (this.isOwningHandle());
        return this.maxBackgroundOperations(this.nativeHandle_);
    }

    public BackupEngineOptions setCallbackTriggerIntervalSize(long l) {
        assert (this.isOwningHandle());
        this.setCallbackTriggerIntervalSize(this.nativeHandle_, l);
        return this;
    }

    public long callbackTriggerIntervalSize() {
        assert (this.isOwningHandle());
        return this.callbackTriggerIntervalSize(this.nativeHandle_);
    }

    private static native long newBackupEngineOptions(String var0);

    private native String backupDir(long var1);

    private native void setBackupEnv(long var1, long var3);

    private native void setShareTableFiles(long var1, boolean var3);

    private native boolean shareTableFiles(long var1);

    private native void setInfoLog(long var1, long var3);

    private native void setSync(long var1, boolean var3);

    private native boolean sync(long var1);

    private native void setDestroyOldData(long var1, boolean var3);

    private native boolean destroyOldData(long var1);

    private native void setBackupLogFiles(long var1, boolean var3);

    private native boolean backupLogFiles(long var1);

    private native void setBackupRateLimit(long var1, long var3);

    private native long backupRateLimit(long var1);

    private native void setBackupRateLimiter(long var1, long var3);

    private native void setRestoreRateLimit(long var1, long var3);

    private native long restoreRateLimit(long var1);

    private native void setRestoreRateLimiter(long var1, long var3);

    private native void setShareFilesWithChecksum(long var1, boolean var3);

    private native boolean shareFilesWithChecksum(long var1);

    private native void setMaxBackgroundOperations(long var1, int var3);

    private native int maxBackgroundOperations(long var1);

    private native void setCallbackTriggerIntervalSize(long var1, long var3);

    private native long callbackTriggerIntervalSize(long var1);

    @Override
    protected final native void disposeInternal(long var1);
}

