/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.pulsar.producer;

import io.cloudevents.CloudEvent;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.storage.pulsar.client.PulsarClientWrapper;
import org.apache.eventmesh.storage.pulsar.config.ClientConfiguration;
import org.apache.eventmesh.storage.pulsar.producer.AbstractProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerImpl
extends AbstractProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProducerImpl.class);
    private final AtomicBoolean started = new AtomicBoolean(false);
    private ClientConfiguration config;
    private PulsarClientWrapper pulsarClient;

    public ProducerImpl(Properties properties, ClientConfiguration config) {
        this(properties);
        this.setConfig(config);
    }

    public ProducerImpl(Properties properties) {
        super(properties);
    }

    public void publish(CloudEvent cloudEvent, SendCallback sendCallback) {
        this.pulsarClient.publish(cloudEvent, sendCallback);
    }

    public void init(Properties properties) {
        new ProducerImpl(properties);
    }

    public void start() {
        this.started.compareAndSet(false, true);
        this.pulsarClient = new PulsarClientWrapper(this.config, this.properties);
    }

    public void shutdown() {
        try {
            this.started.compareAndSet(true, false);
            this.pulsarClient.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isStarted() {
        return this.started.get();
    }

    @Override
    public boolean isClosed() {
        return !this.isStarted();
    }

    public void setConfig(ClientConfiguration config) {
        this.config = config;
    }
}

