/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.lexer;

import com.googlecode.aviator.exception.CompileExpressionErrorException;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.CharToken;
import com.googlecode.aviator.lexer.token.NumberToken;
import com.googlecode.aviator.lexer.token.StringToken;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.lexer.token.Variable;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLexer {
    private char peek;
    private final CharacterIterator iterator;
    private final SymbolTable symbolTable;
    private final Stack<Token<?>> tokenBuffer = new Stack();
    static final char[] VALID_HEX_CHAR = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f'};
    static final char[] OPS = new char[]{'=', '>', '<', '+', '-', '*', '/', '%', '!', '&', '|'};

    public ExpressionLexer(String expression) {
        this.iterator = new StringCharacterIterator(expression);
        this.symbolTable = new SymbolTable();
        this.peek = this.iterator.current();
    }

    public void pushback(Token<?> token) {
        this.tokenBuffer.push(token);
    }

    public Token<?> scan() {
        return this.scan(true);
    }

    public void nextChar() {
        this.peek = this.iterator.next();
    }

    public void prevChar() {
        this.peek = this.iterator.previous();
    }

    public boolean isValidHexChar(char ch) {
        for (char c : VALID_HEX_CHAR) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }

    public int getCurrentIndex() {
        return this.iterator.getIndex();
    }

    public Token<?> scan(boolean analyse) {
        if (!this.tokenBuffer.isEmpty()) {
            return this.tokenBuffer.pop();
        }
        while (true) {
            if (this.peek == '\uffff') {
                return null;
            }
            if (analyse) {
                if (this.peek != ' ' && this.peek != '\t' && this.peek != '\r') {
                    if (this.peek != '\n') break;
                    throw new CompileExpressionErrorException("Aviator doesn't support newline expression at " + this.iterator.getIndex());
                }
            } else {
                char ch = this.peek;
                int index = this.iterator.getIndex();
                this.nextChar();
                return new CharToken(ch, index);
            }
            this.nextChar();
        }
        if (Character.isDigit(this.peek) && this.peek == '0') {
            this.nextChar();
            if (this.peek == 'x' || this.peek == 'X') {
                this.nextChar();
                StringBuffer sb = new StringBuffer();
                int startIndex = this.iterator.getIndex() - 2;
                long value = 0L;
                do {
                    sb.append(this.peek);
                    value = 16L * value + (long)Character.digit(this.peek, 16);
                    this.nextChar();
                } while (this.isValidHexChar(this.peek));
                return new NumberToken(value, sb.toString(), startIndex);
            }
            this.prevChar();
        }
        if (Character.isDigit(this.peek) || this.peek == '.') {
            StringBuffer sb = new StringBuffer();
            int startIndex = this.iterator.getIndex();
            long lval = 0L;
            double dval = 0.0;
            boolean hasDot = false;
            double d = 10.0;
            do {
                sb.append(this.peek);
                if (this.peek == '.') {
                    if (hasDot) {
                        throw new CompileExpressionErrorException("Illegal Number at " + this.iterator.getIndex());
                    }
                    hasDot = true;
                    this.nextChar();
                    continue;
                }
                int digit = Character.digit(this.peek, 10);
                if (!hasDot) {
                    lval = 10L * lval + (long)digit;
                    dval = 10.0 * dval + (double)digit;
                    this.nextChar();
                    continue;
                }
                dval += (double)digit / d;
                d *= 10.0;
                this.nextChar();
            } while (Character.isDigit(this.peek) || this.peek == '.');
            Number value = lval;
            if (hasDot) {
                value = dval;
            }
            return new NumberToken(value, sb.toString(), startIndex);
        }
        if (Character.isJavaIdentifierStart(this.peek)) {
            int startIndex = this.iterator.getIndex();
            StringBuilder sb = new StringBuilder();
            do {
                sb.append(this.peek);
                this.nextChar();
            } while (Character.isJavaIdentifierPart(this.peek) || this.peek == '.');
            String lexeme = sb.toString();
            Variable variable = new Variable(lexeme, startIndex);
            if (this.symbolTable.contains(lexeme)) {
                return this.symbolTable.getVariable(lexeme);
            }
            this.symbolTable.reserve(lexeme, variable);
            return variable;
        }
        if (ExpressionLexer.isBinaryOP(this.peek)) {
            CharToken opToken = new CharToken(this.peek, this.iterator.getIndex());
            this.nextChar();
            return opToken;
        }
        if (this.peek == '\"' || this.peek == '\'') {
            char left = this.peek;
            int startIndex = this.iterator.getIndex();
            StringBuilder sb = new StringBuilder();
            while ((this.peek = this.iterator.next()) != left) {
                if (this.peek == '\uffff') {
                    throw new CompileExpressionErrorException("Illegal String at " + startIndex);
                }
                sb.append(this.peek);
            }
            this.nextChar();
            return new StringToken(sb.toString(), startIndex);
        }
        CharToken token = new CharToken(this.peek, this.iterator.getIndex());
        this.nextChar();
        return token;
    }

    public static boolean isBinaryOP(char ch) {
        for (char tmp : OPS) {
            if (tmp != ch) continue;
            return true;
        }
        return false;
    }
}

