/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.dialect;

import lombok.Generated;
import org.apache.eventmesh.connector.canal.dialect.DbDialect;
import org.apache.eventmesh.connector.canal.template.SqlTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class AbstractDbDialect
implements DbDialect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractDbDialect.class);
    protected int databaseMajorVersion;
    protected int databaseMinorVersion;
    protected String databaseName;
    protected SqlTemplate sqlTemplate;
    protected JdbcTemplate jdbcTemplate;
    protected TransactionTemplate transactionTemplate;
    protected LobHandler lobHandler;

    public AbstractDbDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler) {
        this.jdbcTemplate = jdbcTemplate;
        this.lobHandler = lobHandler;
        this.transactionTemplate = new TransactionTemplate();
        this.transactionTemplate.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager(jdbcTemplate.getDataSource()));
        this.transactionTemplate.setPropagationBehavior(3);
    }

    public AbstractDbDialect(JdbcTemplate jdbcTemplate, LobHandler lobHandler, String name, int majorVersion, int minorVersion) {
        this.jdbcTemplate = jdbcTemplate;
        this.lobHandler = lobHandler;
        this.transactionTemplate = new TransactionTemplate();
        this.transactionTemplate.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager(jdbcTemplate.getDataSource()));
        this.transactionTemplate.setPropagationBehavior(3);
        this.databaseName = name;
        this.databaseMajorVersion = majorVersion;
        this.databaseMinorVersion = minorVersion;
    }

    @Override
    public String getName() {
        return this.databaseName;
    }

    @Override
    public int getMajorVersion() {
        return this.databaseMajorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.databaseMinorVersion;
    }

    @Override
    public String getVersion() {
        return this.databaseMajorVersion + "." + this.databaseMinorVersion;
    }

    @Override
    public LobHandler getLobHandler() {
        return this.lobHandler;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public SqlTemplate getSqlTemplate() {
        return this.sqlTemplate;
    }

    @Override
    public String getShardColumns(String schema, String table) {
        return null;
    }

    @Override
    public void destory() {
    }
}

