/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.sink;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;

public class GtidBatch {
    private int totalBatches;
    private List<List<CanalConnectRecord>> batches;
    private int receivedBatchCount;

    public GtidBatch(int totalBatches) {
        this.totalBatches = totalBatches;
        this.batches = new CopyOnWriteArrayList<List>(new List[totalBatches]);
        this.receivedBatchCount = 0;
    }

    public void addBatch(int batchIndex, List<CanalConnectRecord> batchRecords) {
        this.batches.set(batchIndex, batchRecords);
        ++this.receivedBatchCount;
    }

    public List<List<CanalConnectRecord>> getBatches() {
        return this.batches;
    }

    public boolean isComplete() {
        return this.receivedBatchCount == this.totalBatches;
    }
}

