/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.source.connector;

import com.google.common.util.concurrent.RateLimiter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalMySQLType;
import org.apache.eventmesh.common.config.connector.rdb.canal.JobRdbFullPosition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbColumnDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.mysql.MySQLColumnDef;
import org.apache.eventmesh.common.config.connector.rdb.canal.mysql.MySQLTableDef;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.canal.CanalFullRecordOffset;
import org.apache.eventmesh.common.remote.offset.canal.CanalFullRecordPartition;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.canal.SqlUtils;
import org.apache.eventmesh.connector.canal.source.position.TableFullPosition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalFullProducer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalFullProducer.class);
    private BlockingQueue<List<ConnectRecord>> queue;
    private final DataSource dataSource;
    private final MySQLTableDef tableDefinition;
    private final TableFullPosition tableFullPosition;
    private final JobRdbFullPosition startPosition;
    private static final int LIMIT = 2048;
    private final int flushSize;
    private final AtomicReference<String> choosePrimaryKey = new AtomicReference<Object>(null);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter DATE_STAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private AtomicLong scanCount = new AtomicLong(0L);
    private final RateLimiter pageLimiter;
    private RateLimiter recordLimiter;

    public CanalFullProducer(BlockingQueue<List<ConnectRecord>> queue, DataSource dataSource, MySQLTableDef tableDefinition, JobRdbFullPosition startPosition, int flushSize, int pagePerSecond) {
        this.queue = queue;
        this.dataSource = dataSource;
        this.tableDefinition = tableDefinition;
        this.startPosition = startPosition;
        this.tableFullPosition = (TableFullPosition)JsonUtils.parseObject((String)startPosition.getPrimaryKeyRecords(), TableFullPosition.class);
        this.scanCount.set(startPosition.getHandledRecordCount());
        this.flushSize = flushSize;
        this.pageLimiter = RateLimiter.create((double)pagePerSecond);
    }

    public void choosePrimaryKey() {
        for (RdbColumnDefinition col : this.tableDefinition.getColumnDefinitions().values()) {
            if (this.tableFullPosition.getCurPrimaryKeyCols().get(col.getName()) == null) continue;
            this.choosePrimaryKey.set(col.getName());
            log.info("schema [{}] table [{}] choose primary key [{}]", new Object[]{this.tableDefinition.getSchemaName(), this.tableDefinition.getTableName(), col.getName()});
            return;
        }
        throw new EventMeshException("illegal: can't pick any primary key");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start(AtomicBoolean flag) {
        this.choosePrimaryKey();
        boolean isFirstSelect = true;
        LinkedList<Map<String, Object>> rows = new LinkedList<Map<String, Object>>();
        while (flag.get()) {
            this.pageLimiter.acquire();
            String scanSql = this.generateScanSql(isFirstSelect);
            log.info("scan sql is [{}] , cur position [{}]", (Object)scanSql, (Object)JsonUtils.toJSONString(this.tableFullPosition.getCurPrimaryKeyCols()));
            try (Connection connection = this.dataSource.getConnection();
                 PreparedStatement statement = connection.prepareStatement(scanSql, 1003, 1007);){
                statement.setFetchSize(Integer.MIN_VALUE);
                this.setPrepareStatementValue(statement);
                try {
                    LinkedHashMap<String, Object> lastCol;
                    ResultSet resultSet;
                    block32: {
                        resultSet = statement.executeQuery();
                        lastCol = null;
                        while (flag.get() && resultSet.next()) {
                            LinkedHashMap<String, Object> columnValues = new LinkedHashMap<String, Object>();
                            for (Map.Entry col : this.tableDefinition.getColumnDefinitions().entrySet()) {
                                columnValues.put((String)col.getKey(), this.readColumn(resultSet, (String)col.getKey(), ((MySQLColumnDef)col.getValue()).getType()));
                            }
                            lastCol = columnValues;
                            rows.add(lastCol);
                            this.scanCount.incrementAndGet();
                            if (rows.size() < this.flushSize) continue;
                            this.refreshPosition(lastCol);
                            this.commitConnectRecord(rows, false, this.scanCount.get(), this.startPosition);
                            rows = new LinkedList();
                        }
                        if (lastCol != null && !this.checkIsScanFinish(lastCol)) break block32;
                        log.info("full scan db [{}] table [{}] finish", (Object)this.tableDefinition.getSchemaName(), (Object)this.tableDefinition.getTableName());
                        this.commitConnectRecord(rows, true, this.scanCount.get(), this.startPosition);
                        if (resultSet == null) return;
                        resultSet.close();
                        return;
                    }
                    try {
                        this.refreshPosition(lastCol);
                    }
                    finally {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                }
                catch (InterruptedException ignore) {
                    log.info("full scan db [{}] table [{}] interrupted", (Object)this.tableDefinition.getSchemaName(), (Object)this.tableDefinition.getTableName());
                    Thread.currentThread().interrupt();
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection == null) return;
                    connection.close();
                    return;
                }
            }
            catch (SQLException e) {
                log.error("full source process schema [{}] table [{}] catch SQLException fail", new Object[]{this.tableDefinition.getSchemaName(), this.tableDefinition.getTableName(), e});
                LockSupport.parkNanos(3000000L);
            }
            catch (Exception e) {
                log.error("full source process schema [{}] table [{}] catch unknown exception", new Object[]{this.tableDefinition.getSchemaName(), this.tableDefinition.getTableName(), e});
                return;
            }
            if (!isFirstSelect) continue;
            isFirstSelect = false;
        }
    }

    private void commitConnectRecord(List<Map<String, Object>> rows, boolean isFinished, long migratedCount, JobRdbFullPosition position) throws InterruptedException {
        if (rows == null || rows.isEmpty()) {
            return;
        }
        JobRdbFullPosition jobRdbFullPosition = new JobRdbFullPosition();
        jobRdbFullPosition.setPrimaryKeyRecords(JsonUtils.toJSONString((Object)this.tableFullPosition));
        jobRdbFullPosition.setTableName(this.tableDefinition.getTableName());
        jobRdbFullPosition.setSchema(this.tableDefinition.getSchemaName());
        jobRdbFullPosition.setFinished(isFinished);
        jobRdbFullPosition.setHandledRecordCount(migratedCount);
        jobRdbFullPosition.setMaxCount(position.getMaxCount());
        if (isFinished) {
            jobRdbFullPosition.setPercent(new BigDecimal("100"));
        } else {
            double num = 100.0 * (double)migratedCount * 1.0 / (double)position.getMaxCount();
            String number = Double.toString(num);
            BigDecimal percent = new BigDecimal(number).setScale(2, RoundingMode.HALF_UP);
            jobRdbFullPosition.setPercent(percent);
        }
        CanalFullRecordOffset offset = new CanalFullRecordOffset();
        offset.setPosition(jobRdbFullPosition);
        CanalFullRecordPartition partition = new CanalFullRecordPartition();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("data", JsonUtils.toJSONString(rows));
        dataMap.put("partition", JsonUtils.toJSONString((Object)partition));
        dataMap.put("offset", JsonUtils.toJSONString((Object)offset));
        ArrayList<ConnectRecord> records = new ArrayList<ConnectRecord>();
        records.add(new ConnectRecord((RecordPartition)partition, (RecordOffset)offset, Long.valueOf(System.currentTimeMillis()), (Object)JsonUtils.toJSONString(dataMap).getBytes(StandardCharsets.UTF_8)));
        this.recordLimiter.acquire();
        this.queue.put(records);
    }

    private boolean checkIsScanFinish(Map<String, Object> lastCol) {
        Object lastPrimaryValue = lastCol.get(this.choosePrimaryKey.get());
        Object maxPrimaryValue = this.tableFullPosition.getMaxPrimaryKeyCols().get(this.choosePrimaryKey.get());
        if (lastPrimaryValue instanceof Number) {
            BigDecimal max;
            BigDecimal last = new BigDecimal(String.valueOf(lastPrimaryValue));
            return last.compareTo(max = new BigDecimal(String.valueOf(maxPrimaryValue))) > 0;
        }
        if (lastPrimaryValue instanceof Comparable) {
            return ((Comparable)lastPrimaryValue).compareTo(maxPrimaryValue) > 0;
        }
        return false;
    }

    public Object readColumn(ResultSet rs, String colName, CanalMySQLType colType) throws Exception {
        switch (colType) {
            case TINYINT: 
            case SMALLINT: 
            case MEDIUMINT: 
            case INT: {
                Long valueLong = rs.getLong(colName);
                if (rs.wasNull()) {
                    return null;
                }
                if (valueLong.compareTo((Long)Integer.MAX_VALUE) > 0) {
                    return valueLong;
                }
                return valueLong.intValue();
            }
            case BIGINT: {
                String v = rs.getString(colName);
                if (v == null) {
                    return null;
                }
                BigDecimal valueBigInt = new BigDecimal(v);
                if (valueBigInt.compareTo(BigDecimal.valueOf(Long.MAX_VALUE)) > 0) {
                    return valueBigInt;
                }
                return valueBigInt.longValue();
            }
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: {
                return rs.getBigDecimal(colName);
            }
            case DATE: {
                return rs.getObject(colName, LocalDate.class);
            }
            case TIME: {
                return rs.getObject(colName, LocalTime.class);
            }
            case DATETIME: 
            case TIMESTAMP: {
                return rs.getObject(colName, LocalDateTime.class);
            }
            case YEAR: {
                int year = rs.getInt(colName);
                if (rs.wasNull()) {
                    return null;
                }
                return year;
            }
            case CHAR: 
            case VARCHAR: 
            case TINYTEXT: 
            case TEXT: 
            case MEDIUMTEXT: 
            case LONGTEXT: 
            case ENUM: 
            case SET: 
            case JSON: {
                return rs.getString(colName);
            }
            case BIT: 
            case BINARY: 
            case VARBINARY: 
            case TINYBLOB: 
            case BLOB: 
            case MEDIUMBLOB: 
            case LONGBLOB: {
                return rs.getBytes(colName);
            }
            case GEOMETRY: 
            case GEOMETRY_COLLECTION: 
            case GEOM_COLLECTION: 
            case POINT: 
            case LINESTRING: 
            case POLYGON: 
            case MULTIPOINT: 
            case MULTILINESTRING: 
            case MULTIPOLYGON: {
                byte[] geo = rs.getBytes(colName);
                if (geo == null) {
                    return null;
                }
                return SqlUtils.toGeometry(geo);
            }
        }
        return rs.getObject(colName);
    }

    private void refreshPosition(Map<String, Object> lastCol) {
        LinkedHashMap<String, Object> nextPosition = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.tableFullPosition.getCurPrimaryKeyCols().entrySet()) {
            nextPosition.put(entry.getKey(), lastCol.get(entry.getKey()));
        }
        this.tableFullPosition.setCurPrimaryKeyCols(nextPosition);
    }

    private void setPrepareStatementValue(PreparedStatement statement) throws SQLException {
        String colName = this.choosePrimaryKey.get();
        if (colName == null) {
            return;
        }
        RdbColumnDefinition columnDefinition = (RdbColumnDefinition)this.tableDefinition.getColumnDefinitions().get(colName);
        Object value = this.tableFullPosition.getCurPrimaryKeyCols().get(colName);
        switch (columnDefinition.getJdbcType()) {
            case BIT: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: {
                statement.setBigDecimal(1, new BigDecimal(String.valueOf(value)));
                break;
            }
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case NUMERIC: {
                statement.setDouble(1, new BigDecimal(String.valueOf(value)).doubleValue());
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case LONGNVARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case LONGVARCHAR: 
            case CLOB: 
            case NCLOB: {
                statement.setString(1, String.valueOf(value));
                break;
            }
            case BLOB: 
            case VARBINARY: 
            case BINARY: {
                String str;
                String hexStr = str = String.valueOf(value);
                if (str.startsWith("0x")) {
                    hexStr = str.substring(str.indexOf("0x"));
                }
                byte[] bytes = SqlUtils.hex2bytes(hexStr);
                statement.setBytes(1, bytes);
                break;
            }
            case DATE: {
                String str;
                if (value instanceof Long) {
                    Long val = (Long)value;
                    Instant d = Instant.ofEpochMilli(val);
                    str = d.atZone(ZoneId.systemDefault()).toLocalDateTime().format(DATE_FORMATTER);
                } else if (value instanceof Integer) {
                    Integer val = (Integer)value;
                    Instant d = Instant.ofEpochMilli(val.intValue());
                    str = d.atZone(ZoneId.systemDefault()).toLocalDateTime().format(DATE_FORMATTER);
                } else if (value instanceof String) {
                    str = (String)value;
                } else {
                    if (!(value instanceof LocalDate)) {
                        throw new IllegalArgumentException("unsupported date class type:" + value.getClass().getSimpleName());
                    }
                    str = ((LocalDate)value).format(DATE_FORMATTER);
                }
                statement.setString(1, str);
                break;
            }
            case TIMESTAMP: {
                String str;
                if (value instanceof String) {
                    str = (String)value;
                } else {
                    if (!(value instanceof LocalDateTime)) {
                        throw new IllegalArgumentException("unsupported timestamp class type:" + value.getClass().getSimpleName());
                    }
                    str = ((LocalDateTime)value).format(DATE_STAMP_FORMATTER);
                }
                statement.setString(1, str);
                break;
            }
            default: {
                throw new EventMeshException(String.format("not support the primary key type [%s]", value.getClass()));
            }
        }
    }

    private void generateQueryColumnsSql(StringBuilder builder, Collection<MySQLColumnDef> rdbColDefs) {
        if (rdbColDefs == null || rdbColDefs.isEmpty()) {
            builder.append("*");
            return;
        }
        boolean first = true;
        for (RdbColumnDefinition rdbColumnDefinition : rdbColDefs) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append("`");
            builder.append(rdbColumnDefinition.getName());
            builder.append("`");
        }
    }

    private String generateScanSql(boolean isFirst) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        this.generateQueryColumnsSql(builder, this.tableDefinition.getColumnDefinitions().values());
        builder.append(" from ");
        builder.append("`");
        builder.append(this.tableDefinition.getSchemaName());
        builder.append("`");
        builder.append(".");
        builder.append("`");
        builder.append(this.tableDefinition.getTableName());
        builder.append("`");
        this.buildWhereSql(builder, isFirst);
        builder.append(" limit 2048");
        return builder.toString();
    }

    private void buildWhereSql(StringBuilder builder, boolean isEquals) {
        builder.append(" where ").append("`").append(this.choosePrimaryKey.get()).append("`");
        if (isEquals) {
            builder.append(" >= ? ");
        } else {
            builder.append(" > ? ");
        }
        builder.append(" order by ").append("`").append(this.choosePrimaryKey.get()).append("`").append(" asc ");
    }

    @Generated
    public void setRecordLimiter(RateLimiter recordLimiter) {
        this.recordLimiter = recordLimiter;
    }
}

