/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigField;
import org.apache.eventmesh.common.utils.IPUtils;
import org.assertj.core.util.Strings;

@Config(prefix="eventMesh")
public class CommonConfiguration {
    @ConfigField(field="sysid", beNumber=true, notEmpty=true)
    private String sysID = "5477";
    @ConfigField(field="server.env", notEmpty=true)
    private String eventMeshEnv = "P";
    @ConfigField(field="server.idc", notEmpty=true)
    private String eventMeshIDC = "FT";
    @ConfigField(field="server.name", notEmpty=true)
    private String eventMeshName = "";
    @ConfigField(field="server.cluster", notEmpty=true)
    private String eventMeshCluster = "LS";
    @ConfigField(field="server.hostIp", reload=true)
    private String eventMeshServerIp = null;
    @ConfigField(field="metaStorage.plugin.server-addr", notEmpty=true)
    private String metaStorageAddr = "";
    @ConfigField(field="metaStorage.plugin.type", notEmpty=true)
    private String eventMeshMetaStoragePluginType = "nacos";
    @ConfigField(field="metaStorage.plugin.username")
    private String eventMeshMetaStoragePluginUsername = "";
    @ConfigField(field="metaStorage.plugin.password")
    private String eventMeshMetaStoragePluginPassword = "";
    @ConfigField(field="metaStorage.plugin.enabled")
    private boolean eventMeshServerMetaStorageEnable = false;
    @ConfigField(field="trace.plugin", notEmpty=true)
    private String eventMeshTracePluginType;
    @ConfigField(field="metrics.plugin", notEmpty=true)
    private List<String> eventMeshMetricsPluginType;
    @ConfigField(field="security.plugin.type", notEmpty=true)
    private String eventMeshSecurityPluginType = "security";
    @ConfigField(field="storage.plugin.type", notEmpty=true)
    private String eventMeshStoragePluginType = "standalone";
    @ConfigField(field="security.validation.type.token", notEmpty=true)
    private boolean eventMeshSecurityValidateTypeToken = false;
    @ConfigField(field="server.trace.enabled")
    private boolean eventMeshServerTraceEnable = false;
    @ConfigField(field="server.security.enabled")
    private boolean eventMeshServerSecurityEnable = false;
    @ConfigField(field="security.publickey")
    private String eventMeshSecurityPublickey = "";
    @ConfigField(field="server.provide.protocols", reload=true)
    private List<String> eventMeshProvideServerProtocols;
    @ConfigField(reload=true)
    private String meshGroup;
    @ConfigField(field="server.retry.plugin.type")
    private String eventMeshRetryPluginType = "default";
    @ConfigField(field="registry.plugin.server-addr", notEmpty=true)
    private String registryAddr = "";
    @ConfigField(field="registry.plugin.type", notEmpty=true)
    private String eventMeshRegistryPluginType = "nacos";
    @ConfigField(field="registry.plugin.username")
    private String eventMeshRegistryPluginUsername = "";
    @ConfigField(field="registry.plugin.password")
    private String eventMeshRegistryPluginPassword = "";
    @ConfigField(field="registry.plugin.enabled")
    private boolean eventMeshRegistryPluginEnabled = false;

    public void reload() {
        if (Strings.isNullOrEmpty((String)this.eventMeshServerIp)) {
            this.eventMeshServerIp = IPUtils.getLocalAddress();
        }
        if (CollectionUtils.isEmpty(this.eventMeshProvideServerProtocols)) {
            this.eventMeshProvideServerProtocols = Collections.singletonList("HTTP");
        }
        this.meshGroup = String.join((CharSequence)"-", this.eventMeshEnv, this.eventMeshIDC, this.eventMeshCluster, this.sysID);
    }

    @Generated
    public String getSysID() {
        return this.sysID;
    }

    @Generated
    public String getEventMeshEnv() {
        return this.eventMeshEnv;
    }

    @Generated
    public String getEventMeshIDC() {
        return this.eventMeshIDC;
    }

    @Generated
    public String getEventMeshName() {
        return this.eventMeshName;
    }

    @Generated
    public String getEventMeshCluster() {
        return this.eventMeshCluster;
    }

    @Generated
    public String getEventMeshServerIp() {
        return this.eventMeshServerIp;
    }

    @Generated
    public String getMetaStorageAddr() {
        return this.metaStorageAddr;
    }

    @Generated
    public String getEventMeshMetaStoragePluginType() {
        return this.eventMeshMetaStoragePluginType;
    }

    @Generated
    public String getEventMeshMetaStoragePluginUsername() {
        return this.eventMeshMetaStoragePluginUsername;
    }

    @Generated
    public String getEventMeshMetaStoragePluginPassword() {
        return this.eventMeshMetaStoragePluginPassword;
    }

    @Generated
    public boolean isEventMeshServerMetaStorageEnable() {
        return this.eventMeshServerMetaStorageEnable;
    }

    @Generated
    public String getEventMeshTracePluginType() {
        return this.eventMeshTracePluginType;
    }

    @Generated
    public List<String> getEventMeshMetricsPluginType() {
        return this.eventMeshMetricsPluginType;
    }

    @Generated
    public String getEventMeshSecurityPluginType() {
        return this.eventMeshSecurityPluginType;
    }

    @Generated
    public String getEventMeshStoragePluginType() {
        return this.eventMeshStoragePluginType;
    }

    @Generated
    public boolean isEventMeshSecurityValidateTypeToken() {
        return this.eventMeshSecurityValidateTypeToken;
    }

    @Generated
    public boolean isEventMeshServerTraceEnable() {
        return this.eventMeshServerTraceEnable;
    }

    @Generated
    public boolean isEventMeshServerSecurityEnable() {
        return this.eventMeshServerSecurityEnable;
    }

    @Generated
    public String getEventMeshSecurityPublickey() {
        return this.eventMeshSecurityPublickey;
    }

    @Generated
    public List<String> getEventMeshProvideServerProtocols() {
        return this.eventMeshProvideServerProtocols;
    }

    @Generated
    public String getMeshGroup() {
        return this.meshGroup;
    }

    @Generated
    public String getEventMeshRetryPluginType() {
        return this.eventMeshRetryPluginType;
    }

    @Generated
    public String getRegistryAddr() {
        return this.registryAddr;
    }

    @Generated
    public String getEventMeshRegistryPluginType() {
        return this.eventMeshRegistryPluginType;
    }

    @Generated
    public String getEventMeshRegistryPluginUsername() {
        return this.eventMeshRegistryPluginUsername;
    }

    @Generated
    public String getEventMeshRegistryPluginPassword() {
        return this.eventMeshRegistryPluginPassword;
    }

    @Generated
    public boolean isEventMeshRegistryPluginEnabled() {
        return this.eventMeshRegistryPluginEnabled;
    }

    @Generated
    public void setSysID(String sysID) {
        this.sysID = sysID;
    }

    @Generated
    public void setEventMeshEnv(String eventMeshEnv) {
        this.eventMeshEnv = eventMeshEnv;
    }

    @Generated
    public void setEventMeshIDC(String eventMeshIDC) {
        this.eventMeshIDC = eventMeshIDC;
    }

    @Generated
    public void setEventMeshName(String eventMeshName) {
        this.eventMeshName = eventMeshName;
    }

    @Generated
    public void setEventMeshCluster(String eventMeshCluster) {
        this.eventMeshCluster = eventMeshCluster;
    }

    @Generated
    public void setEventMeshServerIp(String eventMeshServerIp) {
        this.eventMeshServerIp = eventMeshServerIp;
    }

    @Generated
    public void setMetaStorageAddr(String metaStorageAddr) {
        this.metaStorageAddr = metaStorageAddr;
    }

    @Generated
    public void setEventMeshMetaStoragePluginType(String eventMeshMetaStoragePluginType) {
        this.eventMeshMetaStoragePluginType = eventMeshMetaStoragePluginType;
    }

    @Generated
    public void setEventMeshMetaStoragePluginUsername(String eventMeshMetaStoragePluginUsername) {
        this.eventMeshMetaStoragePluginUsername = eventMeshMetaStoragePluginUsername;
    }

    @Generated
    public void setEventMeshMetaStoragePluginPassword(String eventMeshMetaStoragePluginPassword) {
        this.eventMeshMetaStoragePluginPassword = eventMeshMetaStoragePluginPassword;
    }

    @Generated
    public void setEventMeshServerMetaStorageEnable(boolean eventMeshServerMetaStorageEnable) {
        this.eventMeshServerMetaStorageEnable = eventMeshServerMetaStorageEnable;
    }

    @Generated
    public void setEventMeshTracePluginType(String eventMeshTracePluginType) {
        this.eventMeshTracePluginType = eventMeshTracePluginType;
    }

    @Generated
    public void setEventMeshMetricsPluginType(List<String> eventMeshMetricsPluginType) {
        this.eventMeshMetricsPluginType = eventMeshMetricsPluginType;
    }

    @Generated
    public void setEventMeshSecurityPluginType(String eventMeshSecurityPluginType) {
        this.eventMeshSecurityPluginType = eventMeshSecurityPluginType;
    }

    @Generated
    public void setEventMeshStoragePluginType(String eventMeshStoragePluginType) {
        this.eventMeshStoragePluginType = eventMeshStoragePluginType;
    }

    @Generated
    public void setEventMeshSecurityValidateTypeToken(boolean eventMeshSecurityValidateTypeToken) {
        this.eventMeshSecurityValidateTypeToken = eventMeshSecurityValidateTypeToken;
    }

    @Generated
    public void setEventMeshServerTraceEnable(boolean eventMeshServerTraceEnable) {
        this.eventMeshServerTraceEnable = eventMeshServerTraceEnable;
    }

    @Generated
    public void setEventMeshServerSecurityEnable(boolean eventMeshServerSecurityEnable) {
        this.eventMeshServerSecurityEnable = eventMeshServerSecurityEnable;
    }

    @Generated
    public void setEventMeshSecurityPublickey(String eventMeshSecurityPublickey) {
        this.eventMeshSecurityPublickey = eventMeshSecurityPublickey;
    }

    @Generated
    public void setEventMeshProvideServerProtocols(List<String> eventMeshProvideServerProtocols) {
        this.eventMeshProvideServerProtocols = eventMeshProvideServerProtocols;
    }

    @Generated
    public void setMeshGroup(String meshGroup) {
        this.meshGroup = meshGroup;
    }

    @Generated
    public void setEventMeshRetryPluginType(String eventMeshRetryPluginType) {
        this.eventMeshRetryPluginType = eventMeshRetryPluginType;
    }

    @Generated
    public void setRegistryAddr(String registryAddr) {
        this.registryAddr = registryAddr;
    }

    @Generated
    public void setEventMeshRegistryPluginType(String eventMeshRegistryPluginType) {
        this.eventMeshRegistryPluginType = eventMeshRegistryPluginType;
    }

    @Generated
    public void setEventMeshRegistryPluginUsername(String eventMeshRegistryPluginUsername) {
        this.eventMeshRegistryPluginUsername = eventMeshRegistryPluginUsername;
    }

    @Generated
    public void setEventMeshRegistryPluginPassword(String eventMeshRegistryPluginPassword) {
        this.eventMeshRegistryPluginPassword = eventMeshRegistryPluginPassword;
    }

    @Generated
    public void setEventMeshRegistryPluginEnabled(boolean eventMeshRegistryPluginEnabled) {
        this.eventMeshRegistryPluginEnabled = eventMeshRegistryPluginEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommonConfiguration)) {
            return false;
        }
        CommonConfiguration other = (CommonConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEventMeshServerMetaStorageEnable() != other.isEventMeshServerMetaStorageEnable()) {
            return false;
        }
        if (this.isEventMeshSecurityValidateTypeToken() != other.isEventMeshSecurityValidateTypeToken()) {
            return false;
        }
        if (this.isEventMeshServerTraceEnable() != other.isEventMeshServerTraceEnable()) {
            return false;
        }
        if (this.isEventMeshServerSecurityEnable() != other.isEventMeshServerSecurityEnable()) {
            return false;
        }
        if (this.isEventMeshRegistryPluginEnabled() != other.isEventMeshRegistryPluginEnabled()) {
            return false;
        }
        String this$sysID = this.getSysID();
        String other$sysID = other.getSysID();
        if (this$sysID == null ? other$sysID != null : !this$sysID.equals(other$sysID)) {
            return false;
        }
        String this$eventMeshEnv = this.getEventMeshEnv();
        String other$eventMeshEnv = other.getEventMeshEnv();
        if (this$eventMeshEnv == null ? other$eventMeshEnv != null : !this$eventMeshEnv.equals(other$eventMeshEnv)) {
            return false;
        }
        String this$eventMeshIDC = this.getEventMeshIDC();
        String other$eventMeshIDC = other.getEventMeshIDC();
        if (this$eventMeshIDC == null ? other$eventMeshIDC != null : !this$eventMeshIDC.equals(other$eventMeshIDC)) {
            return false;
        }
        String this$eventMeshName = this.getEventMeshName();
        String other$eventMeshName = other.getEventMeshName();
        if (this$eventMeshName == null ? other$eventMeshName != null : !this$eventMeshName.equals(other$eventMeshName)) {
            return false;
        }
        String this$eventMeshCluster = this.getEventMeshCluster();
        String other$eventMeshCluster = other.getEventMeshCluster();
        if (this$eventMeshCluster == null ? other$eventMeshCluster != null : !this$eventMeshCluster.equals(other$eventMeshCluster)) {
            return false;
        }
        String this$eventMeshServerIp = this.getEventMeshServerIp();
        String other$eventMeshServerIp = other.getEventMeshServerIp();
        if (this$eventMeshServerIp == null ? other$eventMeshServerIp != null : !this$eventMeshServerIp.equals(other$eventMeshServerIp)) {
            return false;
        }
        String this$metaStorageAddr = this.getMetaStorageAddr();
        String other$metaStorageAddr = other.getMetaStorageAddr();
        if (this$metaStorageAddr == null ? other$metaStorageAddr != null : !this$metaStorageAddr.equals(other$metaStorageAddr)) {
            return false;
        }
        String this$eventMeshMetaStoragePluginType = this.getEventMeshMetaStoragePluginType();
        String other$eventMeshMetaStoragePluginType = other.getEventMeshMetaStoragePluginType();
        if (this$eventMeshMetaStoragePluginType == null ? other$eventMeshMetaStoragePluginType != null : !this$eventMeshMetaStoragePluginType.equals(other$eventMeshMetaStoragePluginType)) {
            return false;
        }
        String this$eventMeshMetaStoragePluginUsername = this.getEventMeshMetaStoragePluginUsername();
        String other$eventMeshMetaStoragePluginUsername = other.getEventMeshMetaStoragePluginUsername();
        if (this$eventMeshMetaStoragePluginUsername == null ? other$eventMeshMetaStoragePluginUsername != null : !this$eventMeshMetaStoragePluginUsername.equals(other$eventMeshMetaStoragePluginUsername)) {
            return false;
        }
        String this$eventMeshMetaStoragePluginPassword = this.getEventMeshMetaStoragePluginPassword();
        String other$eventMeshMetaStoragePluginPassword = other.getEventMeshMetaStoragePluginPassword();
        if (this$eventMeshMetaStoragePluginPassword == null ? other$eventMeshMetaStoragePluginPassword != null : !this$eventMeshMetaStoragePluginPassword.equals(other$eventMeshMetaStoragePluginPassword)) {
            return false;
        }
        String this$eventMeshTracePluginType = this.getEventMeshTracePluginType();
        String other$eventMeshTracePluginType = other.getEventMeshTracePluginType();
        if (this$eventMeshTracePluginType == null ? other$eventMeshTracePluginType != null : !this$eventMeshTracePluginType.equals(other$eventMeshTracePluginType)) {
            return false;
        }
        List<String> this$eventMeshMetricsPluginType = this.getEventMeshMetricsPluginType();
        List<String> other$eventMeshMetricsPluginType = other.getEventMeshMetricsPluginType();
        if (this$eventMeshMetricsPluginType == null ? other$eventMeshMetricsPluginType != null : !((Object)this$eventMeshMetricsPluginType).equals(other$eventMeshMetricsPluginType)) {
            return false;
        }
        String this$eventMeshSecurityPluginType = this.getEventMeshSecurityPluginType();
        String other$eventMeshSecurityPluginType = other.getEventMeshSecurityPluginType();
        if (this$eventMeshSecurityPluginType == null ? other$eventMeshSecurityPluginType != null : !this$eventMeshSecurityPluginType.equals(other$eventMeshSecurityPluginType)) {
            return false;
        }
        String this$eventMeshStoragePluginType = this.getEventMeshStoragePluginType();
        String other$eventMeshStoragePluginType = other.getEventMeshStoragePluginType();
        if (this$eventMeshStoragePluginType == null ? other$eventMeshStoragePluginType != null : !this$eventMeshStoragePluginType.equals(other$eventMeshStoragePluginType)) {
            return false;
        }
        String this$eventMeshSecurityPublickey = this.getEventMeshSecurityPublickey();
        String other$eventMeshSecurityPublickey = other.getEventMeshSecurityPublickey();
        if (this$eventMeshSecurityPublickey == null ? other$eventMeshSecurityPublickey != null : !this$eventMeshSecurityPublickey.equals(other$eventMeshSecurityPublickey)) {
            return false;
        }
        List<String> this$eventMeshProvideServerProtocols = this.getEventMeshProvideServerProtocols();
        List<String> other$eventMeshProvideServerProtocols = other.getEventMeshProvideServerProtocols();
        if (this$eventMeshProvideServerProtocols == null ? other$eventMeshProvideServerProtocols != null : !((Object)this$eventMeshProvideServerProtocols).equals(other$eventMeshProvideServerProtocols)) {
            return false;
        }
        String this$meshGroup = this.getMeshGroup();
        String other$meshGroup = other.getMeshGroup();
        if (this$meshGroup == null ? other$meshGroup != null : !this$meshGroup.equals(other$meshGroup)) {
            return false;
        }
        String this$eventMeshRetryPluginType = this.getEventMeshRetryPluginType();
        String other$eventMeshRetryPluginType = other.getEventMeshRetryPluginType();
        if (this$eventMeshRetryPluginType == null ? other$eventMeshRetryPluginType != null : !this$eventMeshRetryPluginType.equals(other$eventMeshRetryPluginType)) {
            return false;
        }
        String this$registryAddr = this.getRegistryAddr();
        String other$registryAddr = other.getRegistryAddr();
        if (this$registryAddr == null ? other$registryAddr != null : !this$registryAddr.equals(other$registryAddr)) {
            return false;
        }
        String this$eventMeshRegistryPluginType = this.getEventMeshRegistryPluginType();
        String other$eventMeshRegistryPluginType = other.getEventMeshRegistryPluginType();
        if (this$eventMeshRegistryPluginType == null ? other$eventMeshRegistryPluginType != null : !this$eventMeshRegistryPluginType.equals(other$eventMeshRegistryPluginType)) {
            return false;
        }
        String this$eventMeshRegistryPluginUsername = this.getEventMeshRegistryPluginUsername();
        String other$eventMeshRegistryPluginUsername = other.getEventMeshRegistryPluginUsername();
        if (this$eventMeshRegistryPluginUsername == null ? other$eventMeshRegistryPluginUsername != null : !this$eventMeshRegistryPluginUsername.equals(other$eventMeshRegistryPluginUsername)) {
            return false;
        }
        String this$eventMeshRegistryPluginPassword = this.getEventMeshRegistryPluginPassword();
        String other$eventMeshRegistryPluginPassword = other.getEventMeshRegistryPluginPassword();
        return !(this$eventMeshRegistryPluginPassword == null ? other$eventMeshRegistryPluginPassword != null : !this$eventMeshRegistryPluginPassword.equals(other$eventMeshRegistryPluginPassword));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommonConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEventMeshServerMetaStorageEnable() ? 79 : 97);
        result = result * 59 + (this.isEventMeshSecurityValidateTypeToken() ? 79 : 97);
        result = result * 59 + (this.isEventMeshServerTraceEnable() ? 79 : 97);
        result = result * 59 + (this.isEventMeshServerSecurityEnable() ? 79 : 97);
        result = result * 59 + (this.isEventMeshRegistryPluginEnabled() ? 79 : 97);
        String $sysID = this.getSysID();
        result = result * 59 + ($sysID == null ? 43 : $sysID.hashCode());
        String $eventMeshEnv = this.getEventMeshEnv();
        result = result * 59 + ($eventMeshEnv == null ? 43 : $eventMeshEnv.hashCode());
        String $eventMeshIDC = this.getEventMeshIDC();
        result = result * 59 + ($eventMeshIDC == null ? 43 : $eventMeshIDC.hashCode());
        String $eventMeshName = this.getEventMeshName();
        result = result * 59 + ($eventMeshName == null ? 43 : $eventMeshName.hashCode());
        String $eventMeshCluster = this.getEventMeshCluster();
        result = result * 59 + ($eventMeshCluster == null ? 43 : $eventMeshCluster.hashCode());
        String $eventMeshServerIp = this.getEventMeshServerIp();
        result = result * 59 + ($eventMeshServerIp == null ? 43 : $eventMeshServerIp.hashCode());
        String $metaStorageAddr = this.getMetaStorageAddr();
        result = result * 59 + ($metaStorageAddr == null ? 43 : $metaStorageAddr.hashCode());
        String $eventMeshMetaStoragePluginType = this.getEventMeshMetaStoragePluginType();
        result = result * 59 + ($eventMeshMetaStoragePluginType == null ? 43 : $eventMeshMetaStoragePluginType.hashCode());
        String $eventMeshMetaStoragePluginUsername = this.getEventMeshMetaStoragePluginUsername();
        result = result * 59 + ($eventMeshMetaStoragePluginUsername == null ? 43 : $eventMeshMetaStoragePluginUsername.hashCode());
        String $eventMeshMetaStoragePluginPassword = this.getEventMeshMetaStoragePluginPassword();
        result = result * 59 + ($eventMeshMetaStoragePluginPassword == null ? 43 : $eventMeshMetaStoragePluginPassword.hashCode());
        String $eventMeshTracePluginType = this.getEventMeshTracePluginType();
        result = result * 59 + ($eventMeshTracePluginType == null ? 43 : $eventMeshTracePluginType.hashCode());
        List<String> $eventMeshMetricsPluginType = this.getEventMeshMetricsPluginType();
        result = result * 59 + ($eventMeshMetricsPluginType == null ? 43 : ((Object)$eventMeshMetricsPluginType).hashCode());
        String $eventMeshSecurityPluginType = this.getEventMeshSecurityPluginType();
        result = result * 59 + ($eventMeshSecurityPluginType == null ? 43 : $eventMeshSecurityPluginType.hashCode());
        String $eventMeshStoragePluginType = this.getEventMeshStoragePluginType();
        result = result * 59 + ($eventMeshStoragePluginType == null ? 43 : $eventMeshStoragePluginType.hashCode());
        String $eventMeshSecurityPublickey = this.getEventMeshSecurityPublickey();
        result = result * 59 + ($eventMeshSecurityPublickey == null ? 43 : $eventMeshSecurityPublickey.hashCode());
        List<String> $eventMeshProvideServerProtocols = this.getEventMeshProvideServerProtocols();
        result = result * 59 + ($eventMeshProvideServerProtocols == null ? 43 : ((Object)$eventMeshProvideServerProtocols).hashCode());
        String $meshGroup = this.getMeshGroup();
        result = result * 59 + ($meshGroup == null ? 43 : $meshGroup.hashCode());
        String $eventMeshRetryPluginType = this.getEventMeshRetryPluginType();
        result = result * 59 + ($eventMeshRetryPluginType == null ? 43 : $eventMeshRetryPluginType.hashCode());
        String $registryAddr = this.getRegistryAddr();
        result = result * 59 + ($registryAddr == null ? 43 : $registryAddr.hashCode());
        String $eventMeshRegistryPluginType = this.getEventMeshRegistryPluginType();
        result = result * 59 + ($eventMeshRegistryPluginType == null ? 43 : $eventMeshRegistryPluginType.hashCode());
        String $eventMeshRegistryPluginUsername = this.getEventMeshRegistryPluginUsername();
        result = result * 59 + ($eventMeshRegistryPluginUsername == null ? 43 : $eventMeshRegistryPluginUsername.hashCode());
        String $eventMeshRegistryPluginPassword = this.getEventMeshRegistryPluginPassword();
        result = result * 59 + ($eventMeshRegistryPluginPassword == null ? 43 : $eventMeshRegistryPluginPassword.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommonConfiguration(sysID=" + this.getSysID() + ", eventMeshEnv=" + this.getEventMeshEnv() + ", eventMeshIDC=" + this.getEventMeshIDC() + ", eventMeshName=" + this.getEventMeshName() + ", eventMeshCluster=" + this.getEventMeshCluster() + ", eventMeshServerIp=" + this.getEventMeshServerIp() + ", metaStorageAddr=" + this.getMetaStorageAddr() + ", eventMeshMetaStoragePluginType=" + this.getEventMeshMetaStoragePluginType() + ", eventMeshMetaStoragePluginUsername=" + this.getEventMeshMetaStoragePluginUsername() + ", eventMeshMetaStoragePluginPassword=" + this.getEventMeshMetaStoragePluginPassword() + ", eventMeshServerMetaStorageEnable=" + this.isEventMeshServerMetaStorageEnable() + ", eventMeshTracePluginType=" + this.getEventMeshTracePluginType() + ", eventMeshMetricsPluginType=" + this.getEventMeshMetricsPluginType() + ", eventMeshSecurityPluginType=" + this.getEventMeshSecurityPluginType() + ", eventMeshStoragePluginType=" + this.getEventMeshStoragePluginType() + ", eventMeshSecurityValidateTypeToken=" + this.isEventMeshSecurityValidateTypeToken() + ", eventMeshServerTraceEnable=" + this.isEventMeshServerTraceEnable() + ", eventMeshServerSecurityEnable=" + this.isEventMeshServerSecurityEnable() + ", eventMeshSecurityPublickey=" + this.getEventMeshSecurityPublickey() + ", eventMeshProvideServerProtocols=" + this.getEventMeshProvideServerProtocols() + ", meshGroup=" + this.getMeshGroup() + ", eventMeshRetryPluginType=" + this.getEventMeshRetryPluginType() + ", registryAddr=" + this.getRegistryAddr() + ", eventMeshRegistryPluginType=" + this.getEventMeshRegistryPluginType() + ", eventMeshRegistryPluginUsername=" + this.getEventMeshRegistryPluginUsername() + ", eventMeshRegistryPluginPassword=" + this.getEventMeshRegistryPluginPassword() + ", eventMeshRegistryPluginEnabled=" + this.isEventMeshRegistryPluginEnabled() + ")";
    }

    @Generated
    public CommonConfiguration() {
    }
}

