/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.ConfigInfo;
import org.apache.eventmesh.common.config.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMonitorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigMonitorService.class);
    private static final long TIME_INTERVAL = 30000L;
    private final List<ConfigInfo> configInfoList = new ArrayList<ConfigInfo>();
    private final ScheduledExecutorService configLoader = ThreadPoolFactory.createSingleScheduledExecutor("eventMesh-configLoader");

    public ConfigMonitorService() {
        this.configLoader.scheduleAtFixedRate(this::load, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    public void monitor(ConfigInfo configInfo) {
        this.configInfoList.add(configInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        for (ConfigInfo configInfo : this.configInfoList) {
            try {
                Object object = ConfigService.getInstance().getConfig(configInfo);
                if (configInfo.getObject().equals(object)) continue;
                Field field = configInfo.getObjectField();
                boolean isAccessible = field.isAccessible();
                try {
                    field.setAccessible(true);
                    field.set(configInfo.getInstance(), object);
                }
                finally {
                    field.setAccessible(isAccessible);
                }
                configInfo.setObject(object);
                log.info("config reload success: {}", object);
            }
            catch (Exception e) {
                log.error("config reload failed", (Throwable)e);
            }
        }
    }
}

