/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.remote;

import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum TaskState {
    INIT,
    STARTED,
    RUNNING,
    PAUSE,
    COMPLETE,
    DELETE,
    FAIL;

    private static final TaskState[] STATES_NUM_INDEX;
    private static final Map<String, TaskState> STATES_NAME_INDEX;

    public static TaskState fromIndex(Integer index) {
        if (index == null || index < 0 || index >= STATES_NUM_INDEX.length) {
            return null;
        }
        return STATES_NUM_INDEX[index];
    }

    public static TaskState fromIndex(String index) {
        if (index == null || index.isEmpty()) {
            return null;
        }
        return STATES_NAME_INDEX.get(index);
    }

    @Generated
    public String toString() {
        return "TaskState." + this.name();
    }

    static {
        STATES_NUM_INDEX = TaskState.values();
        STATES_NAME_INDEX = new HashMap<String, TaskState>();
        for (TaskState jobState : STATES_NUM_INDEX) {
            STATES_NAME_INDEX.put(jobState.name(), jobState);
        }
    }
}

