/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.raft.serialize;

import com.alipay.remoting.exception.CodecException;
import com.alipay.remoting.serialization.HessianSerializer;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.eventmesh.meta.raft.serialize.EventMeshSerializerFactory;

public class EventMeshHessianSerializer
extends HessianSerializer {
    private SerializerFactory customizeSerializerFactory = new EventMeshSerializerFactory();
    private static EventMeshHessianSerializer instance;

    private EventMeshHessianSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HessianSerializer getInstance() {
        if (instance != null) return instance;
        Class<EventMeshHessianSerializer> clazz = EventMeshHessianSerializer.class;
        synchronized (EventMeshHessianSerializer.class) {
            if (instance != null) return instance;
            instance = new EventMeshHessianSerializer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public byte[] serialize(Object obj) throws CodecException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
        output.setSerializerFactory(this.customizeSerializerFactory);
        try {
            output.writeObject(obj);
            output.close();
        }
        catch (IOException e) {
            throw new CodecException("IOException occurred when Hessian serializer encode!", (Throwable)e);
        }
        return byteArray.toByteArray();
    }

    public <T> T deserialize(byte[] data, String classOfT) throws CodecException {
        Object resultObject;
        Hessian2Input input = new Hessian2Input((InputStream)new ByteArrayInputStream(data));
        input.setSerializerFactory(this.customizeSerializerFactory);
        try {
            resultObject = input.readObject();
            input.close();
        }
        catch (IOException e) {
            throw new CodecException("IOException occurred when Hessian serializer decode!", (Throwable)e);
        }
        return (T)resultObject;
    }
}

