/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.service.health;

import com.google.protobuf.Any;
import com.google.protobuf.UnsafeByteOperations;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.eventmesh.common.protocol.grpc.adminserver.AdminServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Metadata;
import org.apache.eventmesh.common.protocol.grpc.adminserver.Payload;
import org.apache.eventmesh.common.remote.request.ReportHeartBeatRequest;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.connector.ConnectorRuntimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HealthService.class);
    private final ScheduledExecutorService scheduler;
    private StreamObserver<Payload> requestObserver;
    private StreamObserver<Payload> responseObserver;
    private AdminServiceGrpc.AdminServiceStub adminServiceStub;
    private AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub;
    private ConnectorRuntimeConfig connectorRuntimeConfig;

    public HealthService(AdminServiceGrpc.AdminServiceStub adminServiceStub, AdminServiceGrpc.AdminServiceBlockingStub adminServiceBlockingStub, ConnectorRuntimeConfig connectorRuntimeConfig) {
        this.adminServiceStub = adminServiceStub;
        this.adminServiceBlockingStub = adminServiceBlockingStub;
        this.connectorRuntimeConfig = connectorRuntimeConfig;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.responseObserver = new StreamObserver<Payload>(){

            public void onNext(Payload response) {
                log.debug("health service receive message: {}|{} ", (Object)response.getMetadata(), (Object)response.getBody());
            }

            public void onError(Throwable t) {
                log.error("health service receive error message: {}", (Object)t.getMessage());
            }

            public void onCompleted() {
                log.info("health service finished receive message and completed");
            }
        };
        this.requestObserver = this.adminServiceStub.invokeBiStream(this.responseObserver);
    }

    public void start() {
        this.healthReport();
    }

    public void healthReport() {
        this.scheduler.scheduleAtFixedRate(() -> {
            ReportHeartBeatRequest heartBeat = new ReportHeartBeatRequest();
            heartBeat.setAddress(IPUtils.getLocalAddress());
            heartBeat.setReportedTimeStamp(String.valueOf(System.currentTimeMillis()));
            heartBeat.setJobID(this.connectorRuntimeConfig.getJobID());
            Metadata metadata = Metadata.newBuilder().setType(ReportHeartBeatRequest.class.getSimpleName()).build();
            Payload request = Payload.newBuilder().setMetadata(metadata).setBody(Any.newBuilder().setValue(UnsafeByteOperations.unsafeWrap((byte[])Objects.requireNonNull(JsonUtils.toJSONBytes((Object)heartBeat)))).build()).build();
            this.requestObserver.onNext((Object)request);
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.scheduler.shutdown();
        if (this.requestObserver != null) {
            this.requestObserver.onCompleted();
        }
    }
}

