/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.mongodb.sink.client;

import com.mongodb.BasicDBObject;
import com.mongodb.ConnectionString;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.ReturnDocument;
import io.cloudevents.CloudEvent;
import org.apache.eventmesh.common.config.connector.rdb.mongodb.SinkConnectorConfig;
import org.apache.eventmesh.connector.mongodb.sink.client.Impl.MongodbSinkClient;
import org.apache.eventmesh.connector.mongodb.utils.MongodbCloudEventUtil;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongodbStandaloneSinkClient
implements MongodbSinkClient {
    private final SinkConnectorConfig connectorConfig;
    private volatile boolean started = false;
    private MongoClient client;
    private MongoCollection<Document> cappedCol;
    private MongoCollection<Document> seqCol;

    public MongodbStandaloneSinkClient(SinkConnectorConfig connectorConfig) {
        this.connectorConfig = connectorConfig;
    }

    @Override
    public void init() {
        this.client = MongoClients.create((ConnectionString)new ConnectionString(this.connectorConfig.getUrl()));
        MongoDatabase db = this.client.getDatabase(this.connectorConfig.getDatabase());
        this.cappedCol = db.getCollection(this.connectorConfig.getCollection());
        this.seqCol = db.getCollection("pub_sub_seq");
    }

    @Override
    public void start() {
        if (!this.started) {
            this.started = true;
        }
    }

    @Override
    public void publish(CloudEvent cloudEvent) {
        Document doc = MongodbCloudEventUtil.convertToDocument(cloudEvent);
        int i = this.getNextSeq("flag");
        doc.append("topic", (Object)"flag").append("ts", (Object)i);
        this.cappedCol.insertOne((Object)doc);
    }

    @Override
    public void stop() {
        if (this.started) {
            try {
                this.client.close();
            }
            finally {
                this.started = false;
            }
        }
    }

    public int getNextSeq(String topic) {
        Document query = new Document("topic", (Object)topic);
        Document update = new Document("$inc", (Object)new BasicDBObject("value", (Object)1));
        FindOneAndUpdateOptions options = new FindOneAndUpdateOptions();
        options.upsert(true);
        options.returnDocument(ReturnDocument.AFTER);
        Document result = (Document)this.seqCol.findOneAndUpdate((Bson)query, (Bson)update, options);
        return (Integer)result.get((Object)"value");
    }
}

