/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.trace.pinpoint.config;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.navercorp.pinpoint.profiler.context.grpc.config.GrpcTransportConfig;
import java.util.Properties;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.Config;
import org.apache.eventmesh.common.config.ConfigField;
import org.apache.eventmesh.common.exception.JsonException;
import org.apache.eventmesh.common.utils.RandomStringUtils;

@Config(prefix="eventmesh.trace.pinpoint", path="classPath://pinpoint.properties")
public final class PinpointConfiguration {
    @ConfigField(field="agentId", reload=true)
    private String agentId;
    @ConfigField(field="agentName", reload=true)
    private String agentName;
    @ConfigField(field="applicationName", findEnv=true, notNull=true)
    private String applicationName;
    @ConfigField(field="", reload=true)
    private Properties grpcTransportProperties;
    private GrpcTransportConfig grpcTransportConfig;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    public void reload() {
        if (StringUtils.isBlank((CharSequence)this.agentName)) {
            this.agentName = this.applicationName;
        }
        if (StringUtils.isBlank((CharSequence)this.agentId)) {
            this.agentId = StringUtils.substring((String)this.agentName, (int)0, (int)15) + "-" + RandomStringUtils.generateNum((int)8);
        }
        this.grpcTransportConfig = PinpointConfiguration.convertValue(this.grpcTransportProperties, GrpcTransportConfig.class);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        try {
            return (T)OBJECT_MAPPER.convertValue(fromValue, toValueType);
        }
        catch (IllegalArgumentException e) {
            throw new JsonException("convertValue fromValue to toValueType instance error", (Throwable)e);
        }
    }

    @Generated
    public PinpointConfiguration() {
    }

    @Generated
    public String getAgentId() {
        return this.agentId;
    }

    @Generated
    public String getAgentName() {
        return this.agentName;
    }

    @Generated
    public String getApplicationName() {
        return this.applicationName;
    }

    @Generated
    public Properties getGrpcTransportProperties() {
        return this.grpcTransportProperties;
    }

    @Generated
    public GrpcTransportConfig getGrpcTransportConfig() {
        return this.grpcTransportConfig;
    }

    @Generated
    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    @Generated
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @Generated
    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Generated
    public void setGrpcTransportProperties(Properties grpcTransportProperties) {
        this.grpcTransportProperties = grpcTransportProperties;
    }

    @Generated
    public void setGrpcTransportConfig(GrpcTransportConfig grpcTransportConfig) {
        this.grpcTransportConfig = grpcTransportConfig;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PinpointConfiguration)) {
            return false;
        }
        PinpointConfiguration other = (PinpointConfiguration)o;
        String this$agentId = this.getAgentId();
        String other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !this$agentId.equals(other$agentId)) {
            return false;
        }
        String this$agentName = this.getAgentName();
        String other$agentName = other.getAgentName();
        if (this$agentName == null ? other$agentName != null : !this$agentName.equals(other$agentName)) {
            return false;
        }
        String this$applicationName = this.getApplicationName();
        String other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !this$applicationName.equals(other$applicationName)) {
            return false;
        }
        Properties this$grpcTransportProperties = this.getGrpcTransportProperties();
        Properties other$grpcTransportProperties = other.getGrpcTransportProperties();
        if (this$grpcTransportProperties == null ? other$grpcTransportProperties != null : !((Object)this$grpcTransportProperties).equals(other$grpcTransportProperties)) {
            return false;
        }
        GrpcTransportConfig this$grpcTransportConfig = this.getGrpcTransportConfig();
        GrpcTransportConfig other$grpcTransportConfig = other.getGrpcTransportConfig();
        return !(this$grpcTransportConfig == null ? other$grpcTransportConfig != null : !this$grpcTransportConfig.equals(other$grpcTransportConfig));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : $agentId.hashCode());
        String $agentName = this.getAgentName();
        result = result * 59 + ($agentName == null ? 43 : $agentName.hashCode());
        String $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : $applicationName.hashCode());
        Properties $grpcTransportProperties = this.getGrpcTransportProperties();
        result = result * 59 + ($grpcTransportProperties == null ? 43 : ((Object)$grpcTransportProperties).hashCode());
        GrpcTransportConfig $grpcTransportConfig = this.getGrpcTransportConfig();
        result = result * 59 + ($grpcTransportConfig == null ? 43 : $grpcTransportConfig.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PinpointConfiguration(agentId=" + this.getAgentId() + ", agentName=" + this.getAgentName() + ", applicationName=" + this.getApplicationName() + ", grpcTransportProperties=" + this.getGrpcTransportProperties() + ", grpcTransportConfig=" + this.getGrpcTransportConfig() + ")";
    }
}

