/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.utils;

import java.security.DigestException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class MySQLPasswordEncrypter {
    private static final int CACHING_SHA2_DIGEST_LENGTH = 32;

    public static byte[] scrambleCachingSha2(byte[] password, byte[] seed) throws DigestException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new DigestException(ex);
        }
        byte[] dig1 = new byte[32];
        byte[] dig2 = new byte[32];
        byte[] scramble1 = new byte[32];
        md.update(password, 0, password.length);
        md.digest(dig1, 0, 32);
        md.reset();
        md.update(dig1, 0, dig1.length);
        md.digest(dig2, 0, 32);
        md.reset();
        md.update(dig2, 0, dig1.length);
        md.update(seed, 0, seed.length);
        md.digest(scramble1, 0, 32);
        byte[] mysqlScrambleBuff = new byte[32];
        MySQLPasswordEncrypter.xorString(dig1, mysqlScrambleBuff, scramble1, 32);
        return mysqlScrambleBuff;
    }

    public static final byte[] scramble411(byte[] pass, byte[] seed) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] pass1 = md.digest(pass);
        md.reset();
        byte[] pass2 = md.digest(pass1);
        md.reset();
        md.update(seed);
        byte[] pass3 = md.digest(pass2);
        for (int i = 0; i < pass3.length; ++i) {
            pass3[i] = (byte)(pass3[i] ^ pass1[i]);
        }
        return pass3;
    }

    public static String scramble323(String pass, String seed) {
        byte b;
        double d;
        int i;
        if (pass == null || pass.length() == 0) {
            return pass;
        }
        long[] pw = MySQLPasswordEncrypter.hash(seed);
        long[] msg = MySQLPasswordEncrypter.hash(pass);
        long max = 0x3FFFFFFFL;
        long seed1 = (pw[0] ^ msg[0]) % max;
        long seed2 = (pw[1] ^ msg[1]) % max;
        char[] chars = new char[seed.length()];
        for (i = 0; i < seed.length(); ++i) {
            seed1 = (seed1 * 3L + seed2) % max;
            seed2 = (seed1 + seed2 + 33L) % max;
            d = (double)seed1 / (double)max;
            b = (byte)Math.floor(d * 31.0 + 64.0);
            chars[i] = (char)b;
        }
        seed1 = (seed1 * 3L + seed2) % max;
        seed2 = (seed1 + seed2 + 33L) % max;
        d = (double)seed1 / (double)max;
        b = (byte)Math.floor(d * 31.0);
        i = 0;
        while (i < seed.length()) {
            int n = i++;
            chars[n] = (char)(chars[n] ^ (char)b);
        }
        return new String(chars);
    }

    public static final byte[] scrambleRsa(byte[] publicKeyBytes, byte[] pass, byte[] seed) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] input = new byte[pass.length + 1];
        System.arraycopy(pass, 0, input, 0, pass.length);
        byte[] encryptedPassword = new byte[input.length];
        MySQLPasswordEncrypter.xorString(input, encryptedPassword, seed, input.length);
        String publicKeyPem = new String(publicKeyBytes).replace("\n", "").replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "");
        byte[] certificateData = Base64.getDecoder().decode(publicKeyPem.getBytes());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(certificateData);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(keySpec);
        Cipher cipher = Cipher.getInstance("RSA/ECB/OAEPWithSHA-1AndMGF1Padding");
        cipher.init(1, publicKey);
        return cipher.doFinal(encryptedPassword);
    }

    private static long[] hash(String src) {
        long nr = 1345345333L;
        long add = 7L;
        long nr2 = 305419889L;
        block3: for (int i = 0; i < src.length(); ++i) {
            switch (src.charAt(i)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    long tmp = 0xFF & src.charAt(i);
                    nr ^= ((nr & 0x3FL) + add) * tmp + (nr << 8);
                    nr2 += nr2 << 8 ^ nr;
                    add += tmp;
                }
            }
        }
        long[] result = new long[]{nr & Integer.MAX_VALUE, nr2 & Integer.MAX_VALUE};
        return result;
    }

    private static void xorString(byte[] from, byte[] to, byte[] scramble, int length) {
        int scrambleLength = scramble.length;
        for (int pos = 0; pos < length; ++pos) {
            to[pos] = (byte)(from[pos] ^ scramble[pos % scrambleLength]);
        }
    }
}

