/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.utils;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.Util;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.functions.bridging.BridgingSqlFunction;

public class SetOpRewriteUtil {
    public static List<RexNode> generateEqualsCondition(RelBuilder relBuilder, RelNode left, RelNode right, List<Integer> keys) {
        RexBuilder rexBuilder = relBuilder.getRexBuilder();
        List<RelDataType> leftTypes = RelOptUtil.getFieldTypeList(left.getRowType());
        List<RelDataType> rightTypes = RelOptUtil.getFieldTypeList(right.getRowType());
        List<RexNode> conditions = keys.stream().map(key -> {
            RexInputRef leftRex = rexBuilder.makeInputRef((RelDataType)leftTypes.get((int)key), (int)key);
            RexInputRef rightRex = rexBuilder.makeInputRef((RelDataType)rightTypes.get((int)key), leftTypes.size() + key);
            RexNode equalCond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, leftRex, rightRex);
            return relBuilder.or(equalCond, relBuilder.and(relBuilder.isNull(leftRex), relBuilder.isNull(rightRex)));
        }).collect(Collectors.toList());
        return conditions;
    }

    public static RelNode replicateRows(RelBuilder relBuilder, RelDataType outputRelDataType, List<Integer> fields) {
        RelOptCluster cluster = relBuilder.getCluster();
        BridgingSqlFunction sqlFunction = BridgingSqlFunction.of(cluster, BuiltInFunctionDefinitions.INTERNAL_REPLICATE_ROWS);
        FlinkRelBuilder.pushFunctionScan(relBuilder, sqlFunction, 0, relBuilder.fields(Util.range(fields.size() + 1)), outputRelDataType.getFieldNames());
        Set<CorrelationId> corSet = Collections.singleton(cluster.createCorrel());
        RelNode output = relBuilder.join(JoinRelType.INNER, (RexNode)relBuilder.literal(true), corSet).project(relBuilder.fields(Util.range(fields.size() + 1, fields.size() * 2 + 1))).build();
        return output;
    }
}

