/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.fory.format.encoder;

import org.apache.fory.codegen.Expression;
import org.apache.fory.codegen.Expression.Invoke;
import org.apache.fory.codegen.Expression.Reference;
import org.apache.fory.format.row.binary.BinaryMap;
import org.apache.fory.format.row.binary.CompactBinaryMap;
import org.apache.fory.format.row.binary.writer.BaseBinaryRowWriter;
import org.apache.fory.format.row.binary.writer.BinaryArrayWriter;
import org.apache.fory.format.row.binary.writer.CompactBinaryArrayWriter;
import org.apache.fory.format.row.binary.writer.CompactBinaryRowWriter;
import org.apache.fory.reflect.TypeRef;

class CompactMapEncoderBuilder extends MapEncoderBuilder {

  public CompactMapEncoderBuilder(final TypeRef<?> clsType, final TypeRef<?> beanType) {
    super(clsType, beanType);
  }

  @Override
  protected Invoke beanWriterReset(
      final Expression writer, final Reference rowWriter, final Expression ordinal) {
    return new Invoke(writer, "resetFor", rowWriter, ordinal);
  }

  @Override
  protected TypeRef<? extends BaseBinaryRowWriter> rowWriterType() {
    return TypeRef.of(CompactBinaryRowWriter.class);
  }

  @Override
  protected TypeRef<? extends BinaryArrayWriter> arrayWriterType() {
    return TypeRef.of(CompactBinaryArrayWriter.class);
  }

  @Override
  protected TypeRef<? extends BinaryMap> binaryMapType() {
    return TypeRef.of(CompactBinaryMap.class);
  }

  @Override
  protected String codecSuffix() {
    return "CompactCodec";
  }

  @Override
  protected Expression createSchemaFromStructField(final Expression structField) {
    return CompactRowEncoderBuilder.sortSchema(super.createSchemaFromStructField(structField));
  }
}
