/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.client.Pool;
import org.apache.geode.cache.client.PoolManager;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.admin.ClientHealthMonitoringRegion;
import org.apache.geode.internal.admin.remote.ClientHealthStats;
import org.apache.geode.internal.cache.CacheClientStatus;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionStatus;
import org.apache.geode.internal.cache.RegionStatus;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.inet.LocalHostUtil;

@Deprecated
public class GemFireMemberStatus
implements Serializable {
    private static final long serialVersionUID = 3389997790525991310L;
    protected boolean _isClient;
    protected boolean _isServer;
    protected boolean _isGatewayHub;
    protected boolean _isLocator;
    protected boolean _isPrimaryGatewayHub;
    protected Object _gatewayHubStatus;
    protected boolean _isConnected;
    protected Serializable _memberId;
    protected Set _connectedPeers;
    protected Set _connectedServers;
    protected Set _unconnectedServers;
    protected Set _connectedClients;
    protected Map _connectedIncomingGateways;
    protected Map _outgoingGateways;
    protected Map _clientHostNames;
    protected Map _clientQueueSizes;
    protected Map _gatewayQueueSizes;
    protected Map _regionStatuses;
    protected Map _clientHealthStats;
    protected String _memberName;
    protected int _mcastPort;
    protected int _serverPort;
    protected InetAddress _mcastAddress;
    protected String _bindAddress;
    protected String _locators;
    protected InetAddress _hostAddress;
    protected long _maximumHeapSize;
    protected long _freeHeapSize;
    protected long upTime = -1L;
    protected final transient Cache cache;

    public GemFireMemberStatus() {
        this(null);
    }

    public GemFireMemberStatus(Cache cache) {
        this.cache = cache;
        DistributedSystem ds = null;
        if (cache != null) {
            ds = cache.getDistributedSystem();
        }
        this.initialize(ds);
    }

    public boolean getIsConnected() {
        return this._isConnected;
    }

    protected void setIsConnected(boolean isConnected) {
        this._isConnected = isConnected;
    }

    public boolean getIsClient() {
        return this._isClient;
    }

    protected void setIsClient(boolean isClient) {
        this._isClient = isClient;
    }

    public boolean getIsServer() {
        return this._isServer;
    }

    protected void setIsServer(boolean isServer) {
        this._isServer = isServer;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    protected void setServerPort(int port) {
        this._serverPort = port;
    }

    public boolean getIsGatewayHub() {
        return this._isGatewayHub;
    }

    protected void setIsGatewayHub(boolean isGatewayHub) {
        this._isGatewayHub = isGatewayHub;
    }

    public boolean getIsLocator() {
        return this._isLocator;
    }

    protected void setIsLocator(boolean isLocator) {
        this._isLocator = isLocator;
    }

    public boolean getIsPrimaryGatewayHub() {
        return this._isPrimaryGatewayHub;
    }

    protected void setIsPrimaryGatewayHub(boolean isPrimaryGatewayHub) {
        this._isPrimaryGatewayHub = isPrimaryGatewayHub;
    }

    public Object getGatewayHubStatus() {
        return this._gatewayHubStatus;
    }

    public boolean getIsSecondaryGatewayHub() {
        return !this._isPrimaryGatewayHub;
    }

    public Set getConnectedPeers() {
        return this._connectedPeers;
    }

    protected void setConnectedPeers(Set connectedPeers) {
        this._connectedPeers = connectedPeers;
    }

    public Set getConnectedServers() {
        return this._connectedServers;
    }

    protected void setConnectedServers(Set connectedServers) {
        this._connectedServers = connectedServers;
    }

    protected void addConnectedServer(String connectedServer) {
        this._connectedServers.add(connectedServer);
    }

    public Set getUnconnectedServers() {
        return this._unconnectedServers;
    }

    protected void setUnconnectedServers(Set unconnectedServers) {
        this._unconnectedServers = unconnectedServers;
    }

    protected void addUnconnectedServer(String unconnectedServer) {
        this._unconnectedServers.add(unconnectedServer);
    }

    public Set getConnectedClients() {
        return this._connectedClients;
    }

    protected void addConnectedClient(String connectedClient) {
        this._connectedClients.add(connectedClient);
    }

    public Map getOutgoingGateways() {
        return this._outgoingGateways;
    }

    public Map getConnectedIncomingGateways() {
        return this._connectedIncomingGateways;
    }

    protected void setConnectedIncomingGateways(Map connectedIncomingGateways) {
        this._connectedIncomingGateways = connectedIncomingGateways;
    }

    public Map getClientQueueSizes() {
        return this._clientQueueSizes;
    }

    protected void setClientQueueSizes(Map clientQueueSizes) {
        this._clientQueueSizes = clientQueueSizes;
    }

    public int getClientQueueSize(String clientMemberId) {
        Integer clientQueueSize = (Integer)this.getClientQueueSizes().get(clientMemberId);
        return clientQueueSize == null ? 0 : clientQueueSize;
    }

    protected void putClientQueueSize(String clientMemberId, int size) {
        this.getClientQueueSizes().put(clientMemberId, size);
    }

    public Map getClientHealthStats() {
        return this._clientHealthStats;
    }

    protected void setClientHealthStats(Map stats) {
        this._clientHealthStats = stats;
    }

    public Object getClientHealthStats(String clientID) {
        return this._clientHealthStats.get(clientID);
    }

    protected void setClientHealthStats(String clientID, ClientHealthStats stats) {
        this._clientHealthStats.put(clientID, stats);
    }

    protected void putClientHostName(String clientId, String hostName) {
        this._clientHostNames.put(clientId, hostName);
    }

    public String getClientHostName(String clientId) {
        return (String)this._clientHostNames.get(clientId);
    }

    public Map getRegionStatuses() {
        return this._regionStatuses;
    }

    public Object getRegionStatus(String fullRegionPath) {
        return this.getRegionStatuses().get(fullRegionPath);
    }

    protected void putRegionStatus(String fullRegionPath, RegionStatus status) {
        this.getRegionStatuses().put(fullRegionPath, status);
    }

    public Serializable getMemberId() {
        return this._memberId;
    }

    protected void setMemberId(Serializable memberId) {
        this._memberId = memberId;
    }

    public String getMemberName() {
        return this._memberName;
    }

    protected void setMemberName(String memberName) {
        this._memberName = memberName;
    }

    public int getMcastPort() {
        return this._mcastPort;
    }

    protected void setMcastPort(int mcastPort) {
        this._mcastPort = mcastPort;
    }

    public InetAddress getMcastAddress() {
        return this._mcastAddress;
    }

    protected void setMcastAddress(InetAddress mcastAddress) {
        this._mcastAddress = mcastAddress;
    }

    public InetAddress getHostAddress() {
        return this._hostAddress;
    }

    protected void setHostAddress(InetAddress hostAddress) {
        this._hostAddress = hostAddress;
    }

    public String getBindAddress() {
        return this._bindAddress;
    }

    protected void setBindAddress(String bindAddress) {
        this._bindAddress = bindAddress;
    }

    public String getLocators() {
        return this._locators;
    }

    protected void setLocators(String locators) {
        this._locators = locators;
    }

    public long getMaximumHeapSize() {
        return this._maximumHeapSize;
    }

    protected void setMaximumHeapSize(long size) {
        this._maximumHeapSize = size;
    }

    public long getFreeHeapSize() {
        return this._freeHeapSize;
    }

    protected void setFreeHeapSize(long size) {
        this._freeHeapSize = size;
    }

    public long getUsedHeapSize() {
        return this.getMaximumHeapSize() - this.getFreeHeapSize();
    }

    public long getUpTime() {
        return this.upTime;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public String toString() {
        return "GemFireMemberStatus[isConnected=" + this._isConnected + "; memberName=" + this._memberName + "; memberId=" + this._memberId + "; hostAddress=" + this._hostAddress + "; mcastPort=" + this._mcastPort + "; mcastAddress=" + this._mcastAddress + "; bindAddress=" + this._bindAddress + "; serverPort=" + this._serverPort + "; locators=" + this._locators + "; isClient=" + this._isClient + "; isServer=" + this._isServer + "; isGatewayHub=" + this._isGatewayHub + "; isLocator=" + this._isLocator + "; isPrimaryGatewayHub=" + this._isPrimaryGatewayHub + "; gatewayHubStatus=" + this._gatewayHubStatus + "; connectedPeers=" + this._connectedPeers + "; connectedServers=" + this._connectedServers + "; unconnectedServers=" + this._unconnectedServers + "; connectedClients=" + this._connectedClients + "; clientHostNames=" + this._clientHostNames + "; clientQueueSizes=" + this._clientQueueSizes + "; clientHealthStats=" + this._clientHealthStats + "; gatewayQueueSizes=" + this._gatewayQueueSizes + "; regionStatuses=" + this._regionStatuses + "; maximumHeapSize=" + this._maximumHeapSize + "; freeHeapSize=" + this._freeHeapSize + "; upTime=" + this.upTime + "]";
    }

    protected void initialize(DistributedSystem distributedSystem) {
        this.initializeInstanceVariables();
        if (this.cache != null) {
            this.initializeServer();
            this.initializeClient();
            this.initializeRegionSizes();
        }
        if (distributedSystem != null) {
            this.initializeAll(distributedSystem);
        }
        if (Locator.getLocators().size() > 0) {
            this.setIsLocator(true);
        }
    }

    protected void initializeInstanceVariables() {
        this._connectedClients = new HashSet();
        this._clientQueueSizes = new HashMap();
        this._clientHealthStats = new HashMap();
        this._clientHostNames = new HashMap();
        this._outgoingGateways = new HashMap();
        this._connectedIncomingGateways = new HashMap();
        this._gatewayQueueSizes = new HashMap();
        this._connectedServers = new HashSet();
        this._unconnectedServers = new HashSet();
        this._connectedPeers = new HashSet();
        this._regionStatuses = new HashMap();
    }

    protected void initializeServer() {
        List<CacheServer> servers = this.cache.getCacheServers();
        if (servers.size() == 0) {
            this.setIsServer(false);
        } else {
            this.setIsServer(true);
            Map allConnectedClients = InternalClientMembership.getStatusForAllClientsIgnoreSubscriptionStatus();
            for (Object o : allConnectedClients.values()) {
                CacheClientStatus ccs = (CacheClientStatus)o;
                this.addConnectedClient(ccs.getMemberId());
                this.putClientHostName(ccs.getMemberId(), ccs.getHostAddress());
            }
            Map clientQueueSize = this.getClientIDMap(InternalClientMembership.getClientQueueSizes((InternalCache)this.cache));
            this.setClientQueueSizes(clientQueueSize);
            CacheServer server = (CacheServer)servers.toArray()[0];
            this.setServerPort(server.getPort());
            Region clientHealthMonitoringRegion = ClientHealthMonitoringRegion.getInstance((InternalCache)this.cache);
            if (clientHealthMonitoringRegion != null) {
                String[] clients;
                for (String clientId : clients = clientHealthMonitoringRegion.keySet().toArray(new String[0])) {
                    ClientHealthStats stats = (ClientHealthStats)clientHealthMonitoringRegion.get(clientId);
                    this.setClientHealthStats(clientId, stats);
                }
            }
        }
    }

    private Map getClientIDMap(Map ClientProxyMembershipIDMap) {
        HashMap<String, Integer> clientIdMap = new HashMap<String, Integer>();
        Set entrySet = ClientProxyMembershipIDMap.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            ClientProxyMembershipID key = (ClientProxyMembershipID)entry.getKey();
            Integer size = (Integer)entry.getValue();
            clientIdMap.put(key.getDSMembership(), size);
        }
        return clientIdMap;
    }

    protected void initializeClient() {
        Map<String, Pool> poolMap = PoolManager.getAll();
        if (poolMap.size() == 0) {
            this.setIsClient(false);
        } else {
            this.setIsClient(true);
            Map connectedServers = InternalClientMembership.getConnectedServers();
            if (!connectedServers.isEmpty()) {
                Iterator iterator = connectedServers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = iterator.next();
                    String server = (String)entry.getKey();
                    this.addConnectedServer(server);
                }
            }
        }
    }

    protected void initializeAll(DistributedSystem distributedSystem) {
        this.setIsConnected(true);
        this.initializeDistributedSystem(distributedSystem);
        this.initializePeers(distributedSystem);
        this.initializeMemory();
    }

    protected void initializeDistributedSystem(DistributedSystem distributedSystem) {
        InternalDistributedSystem ids = (InternalDistributedSystem)distributedSystem;
        this.setMemberId((Serializable)((Object)ids.getMemberId()));
        DistributionConfig config = ids.getConfig();
        this.setMemberName(config.getName());
        this.setMcastPort(config.getMcastPort());
        this.setMcastAddress(config.getMcastAddress());
        String bindAddress = config.getBindAddress();
        this.setBindAddress(bindAddress);
        this.setLocators(config.getLocators());
        this.setUpTime(System.currentTimeMillis() - ids.getStartTime());
        try {
            this.setHostAddress(bindAddress != null && bindAddress.length() > 0 ? InetAddress.getByName(bindAddress) : LocalHostUtil.getLocalHost());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void initializePeers(DistributedSystem distributedSystem) {
        InternalDistributedSystem ids = (InternalDistributedSystem)distributedSystem;
        DistributionManager dm = ids.getDistributionManager();
        Set<InternalDistributedMember> connections = dm.getOtherNormalDistributionManagerIds();
        HashSet<String> connectionsIDs = new HashSet<String>(connections.size());
        Iterator<InternalDistributedMember> iterator = connections.iterator();
        while (iterator.hasNext()) {
            InternalDistributedMember connection;
            InternalDistributedMember idm = connection = iterator.next();
            connectionsIDs.add(idm.getId());
        }
        this.setConnectedPeers(connectionsIDs);
    }

    protected void initializeMemory() {
        Runtime rt = Runtime.getRuntime();
        this.setMaximumHeapSize(rt.maxMemory());
        this.setFreeHeapSize(rt.freeMemory());
    }

    protected void initializeRegionSizes() {
        for (Region<?, ?> region : this.cache.rootRegions()) {
            LocalRegion rootRegion = (LocalRegion)region;
            if (rootRegion instanceof HARegion) continue;
            RegionStatus rootRegionStatus = rootRegion instanceof PartitionedRegion ? new PartitionedRegionStatus((PartitionedRegion)rootRegion) : new RegionStatus(rootRegion);
            this.putRegionStatus(rootRegion.getFullPath(), rootRegionStatus);
            for (Object o : rootRegion.subregions(true)) {
                LocalRegion subRegion = (LocalRegion)o;
                RegionStatus subRegionStatus = subRegion instanceof PartitionedRegion ? new PartitionedRegionStatus((PartitionedRegion)subRegion) : new RegionStatus(subRegion);
                this.putRegionStatus(subRegion.getFullPath(), subRegionStatus);
            }
        }
    }
}

