/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.asyncqueue.internal;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.internal.AsyncEventQueueStats;
import org.apache.geode.cache.asyncqueue.internal.InternalAsyncEventQueue;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.wan.InternalGatewaySender;

public class AsyncEventQueueImpl
implements InternalAsyncEventQueue {
    public static final String ASYNC_EVENT_QUEUE_PREFIX = "AsyncEventQueue_";
    private final InternalGatewaySender sender;
    private final AsyncEventListener asyncEventListener;

    public AsyncEventQueueImpl(InternalGatewaySender sender, AsyncEventListener asyncEventListener) {
        this.sender = sender;
        this.asyncEventListener = asyncEventListener;
    }

    @Override
    public void resumeEventDispatching() {
        this.sender.resume();
    }

    @Override
    public boolean isDispatchingPaused() {
        return this.sender.isPaused();
    }

    @Override
    public String getId() {
        return AsyncEventQueueImpl.getAsyncEventQueueIdFromSenderId(this.sender.getId());
    }

    @Override
    public AsyncEventListener getAsyncEventListener() {
        return this.asyncEventListener;
    }

    @Override
    public List<GatewayEventFilter> getGatewayEventFilters() {
        return this.sender.getGatewayEventFilters();
    }

    @Override
    public GatewayEventSubstitutionFilter getGatewayEventSubstitutionFilter() {
        return this.sender.getGatewayEventSubstitutionFilter();
    }

    @Override
    public int getBatchSize() {
        return this.sender.getBatchSize();
    }

    @Override
    public String getDiskStoreName() {
        return this.sender.getDiskStoreName();
    }

    @Override
    public int getBatchTimeInterval() {
        return this.sender.getBatchTimeInterval();
    }

    @Override
    public boolean isBatchConflationEnabled() {
        return this.sender.isBatchConflationEnabled();
    }

    @Override
    public int getMaximumQueueMemory() {
        return this.sender.getMaximumQueueMemory();
    }

    @Override
    public boolean isPersistent() {
        return this.sender.isPersistenceEnabled();
    }

    @Override
    public boolean isDiskSynchronous() {
        return this.sender.isDiskSynchronous();
    }

    @Override
    public int getDispatcherThreads() {
        return this.sender.getDispatcherThreads();
    }

    @Override
    public GatewaySender.OrderPolicy getOrderPolicy() {
        return this.sender.getOrderPolicy();
    }

    @Override
    public boolean isPrimary() {
        return this.sender.isPrimary();
    }

    @Override
    public int size() {
        return this.sender.getEventProcessor().getTotalQueueSize();
    }

    @Override
    public InternalGatewaySender getSender() {
        return this.sender;
    }

    @Override
    public AsyncEventQueueStats getStatistics() {
        return (AsyncEventQueueStats)this.sender.getStatistics();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AsyncEventQueueImpl)) {
            return false;
        }
        AsyncEventQueueImpl other = (AsyncEventQueueImpl)obj;
        return other.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static String getSenderIdFromAsyncEventQueueId(String asyncQueueId) {
        return ASYNC_EVENT_QUEUE_PREFIX + asyncQueueId;
    }

    public static String getAsyncEventQueueIdFromSenderId(String senderId) {
        if (!senderId.startsWith(ASYNC_EVENT_QUEUE_PREFIX)) {
            return senderId;
        }
        return senderId.substring(ASYNC_EVENT_QUEUE_PREFIX.length());
    }

    public static boolean isAsyncEventQueue(String senderId) {
        return senderId.startsWith(ASYNC_EVENT_QUEUE_PREFIX);
    }

    @Override
    public boolean isParallel() {
        return this.sender.isParallel();
    }

    public boolean isMetaQueue() {
        return this.sender.getIsMetaQueue();
    }

    @Override
    public void stop() {
        if (this.sender.isRunning()) {
            this.sender.stop();
        }
    }

    @Override
    public void destroy() {
        this.destroy(true);
    }

    public void destroy(boolean initiator) {
        InternalCache cache = this.sender.getCache();
        this.sender.destroy(initiator);
        cache.removeAsyncEventQueue(this);
    }

    @Override
    public boolean isForwardExpirationDestroy() {
        return this.sender.isForwardExpirationDestroy();
    }

    public boolean waitUntilFlushed(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sender.waitUntilFlushed(timeout, unit);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.getId() + ",isRunning=" + this.sender.isRunning() + "}";
    }
}

