/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.EntryDestroyedException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.StatisticsDisabledException;
import org.apache.geode.internal.cache.CacheStatisticsImpl;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;

class ExpiryRegionEntry
implements Region.Entry {
    private final LocalRegion region;
    private final RegionEntry regionEntry;

    ExpiryRegionEntry(LocalRegion region, RegionEntry regionEntry) {
        this.region = region;
        this.regionEntry = regionEntry;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.regionEntry == null ? 0 : this.regionEntry.hashCode());
        result = 31 * result + (this.region == null ? 0 : this.region.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExpiryRegionEntry other = (ExpiryRegionEntry)obj;
        if (this.regionEntry == null ? other.regionEntry != null : !this.regionEntry.equals(other.regionEntry)) {
            return false;
        }
        if (this.region == null) {
            return other.region == null;
        }
        return this.region.equals(other.region);
    }

    public String toString() {
        return "region=" + this.region.getFullPath() + ", key=" + this.getKey() + " value=" + this.getValue();
    }

    public Region getRegion() {
        return this.region;
    }

    private RegionEntry getCheckedRegionEntry() throws EntryNotFoundException {
        if (this.regionEntry.isDestroyedOrRemoved()) {
            throw new EntryNotFoundException("Entry for key " + this.regionEntry.getKey() + " no longer exists");
        }
        return this.regionEntry;
    }

    @Override
    public Object getValue() {
        Object value = this.region.getDeserialized(this.getCheckedRegionEntry(), false, false, false, false);
        if (value == null) {
            throw new EntryDestroyedException(this.getKey().toString());
        }
        if (Token.isInvalid(value)) {
            return null;
        }
        return value;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public CacheStatistics getStatistics() {
        LocalRegion lr = this.region;
        if (!lr.isStatisticsEnabled()) {
            throw new StatisticsDisabledException(String.format("Statistics disabled for region '%s'", lr.getFullPath()));
        }
        return new CacheStatisticsImpl(this.getCheckedRegionEntry(), lr);
    }

    @Override
    public Object getUserAttribute() {
        return this.region.getEntryUserAttributes().get(this.getKey());
    }

    @Override
    public Object setUserAttribute(Object userAttribute) {
        return this.region.getEntryUserAttributes().put(this.getKey(), userAttribute);
    }

    @Override
    public boolean isDestroyed() {
        return this.regionEntry.isDestroyedOrRemoved();
    }

    @Override
    public Object setValue(Object value) {
        return this.region.put(this.getKey(), value);
    }

    @Override
    public Object getKey() {
        return this.regionEntry.getKey();
    }
}

