/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance.model;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.partition.PartitionMemberInfo;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.FixedPartitionAttributesImpl;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;
import org.apache.geode.internal.cache.partitioned.PRLoad;
import org.apache.geode.internal.cache.partitioned.PartitionMemberInfoImpl;
import org.apache.geode.internal.cache.partitioned.rebalance.BucketOperator;
import org.apache.geode.internal.cache.partitioned.rebalance.model.AddressComparor;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Bucket;
import org.apache.geode.internal.cache.partitioned.rebalance.model.BucketRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;
import org.apache.geode.internal.cache.partitioned.rebalance.model.MemberRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Move;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class PartitionedRegionLoadModel {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final Comparator<Bucket> REDUNDANCY_COMPARATOR = (o1, o2) -> {
        int result = o1.getRedundancy() - o2.getRedundancy();
        if (result == 0) {
            result = Float.compare(o2.getLoad(), o1.getLoad());
        }
        if (result == 0) {
            result = o1.getId() - o2.getId();
        }
        return result;
    };
    private static final long MEGABYTES = 0x100000L;
    @Immutable
    public static final MemberRollup INVALID_MEMBER = new MemberRollup(null, null, false, false);
    private final BucketRollup[] buckets;
    private final Map<InternalDistributedMember, MemberRollup> members = new HashMap<InternalDistributedMember, MemberRollup>();
    private final Set<String> allColocatedRegions = new HashSet<String>();
    private final SortedSet<BucketRollup> lowRedundancyBuckets = new TreeSet<Bucket>(REDUNDANCY_COMPARATOR);
    private SortedSet<BucketRollup> overRedundancyBuckets = null;
    private final Collection<Move> attemptedPrimaryMoves = new HashSet<Move>();
    private final Collection<Move> attemptedBucketMoves = new HashSet<Move>();
    private final Collection<Move> attemptedBucketCreations = new HashSet<Move>();
    private final Collection<Move> attemptedBucketRemoves = new HashSet<Move>();
    private final BucketOperator operator;
    private final int requiredRedundancy;
    private float primaryAverage = -1.0f;
    private float averageLoad = -1.0f;
    private double minPrimaryImprovement = -1.0;
    private double minImprovement = -1.0;
    private final AddressComparor addressComparor;
    private final Set<InternalDistributedMember> criticalMembers;
    private final PartitionedRegion partitionedRegion;

    public PartitionedRegionLoadModel(BucketOperator operator, int redundancyLevel, int numBuckets, AddressComparor addressComparor, Set<InternalDistributedMember> criticalMembers, PartitionedRegion region) {
        this.operator = operator;
        this.requiredRedundancy = redundancyLevel;
        this.buckets = new BucketRollup[numBuckets];
        this.addressComparor = addressComparor;
        this.criticalMembers = criticalMembers;
        this.partitionedRegion = region;
    }

    public void addRegion(String region, Collection<? extends InternalPartitionDetails> memberDetailSet, OfflineMemberDetails offlineDetails, boolean enforceLocalMaxMemory) {
        InternalDistributedMember memberId;
        this.allColocatedRegions.add(region);
        HashMap<InternalDistributedMember, Member> regionMember = new HashMap<InternalDistributedMember, Member>();
        Bucket[] regionBuckets = new Bucket[this.buckets.length];
        for (InternalPartitionDetails internalPartitionDetails : memberDetailSet) {
            memberId = (InternalDistributedMember)internalPartitionDetails.getDistributedMember();
            boolean isCritical = this.criticalMembers.contains(memberId);
            Member member = new Member(this.addressComparor, memberId, internalPartitionDetails.getPRLoad().getWeight(), internalPartitionDetails.getConfiguredMaxMemory(), isCritical, enforceLocalMaxMemory);
            regionMember.put(memberId, member);
            PRLoad load = internalPartitionDetails.getPRLoad();
            for (int i = 0; i < regionBuckets.length; ++i) {
                if (!(load.getReadLoad(i) > 0.0f)) continue;
                Bucket bucket = regionBuckets[i];
                if (bucket == null) {
                    Set<PersistentMemberID> offlineMembers = offlineDetails.getOfflineMembers(i);
                    regionBuckets[i] = bucket = new Bucket(i, load.getReadLoad(i), internalPartitionDetails.getBucketSize(i), offlineMembers);
                }
                bucket.addMember(member);
                if (!(load.getWriteLoad(i) > 0.0f)) continue;
                if (bucket.getPrimary() == null) {
                    bucket.setPrimary(member, load.getWriteLoad(i));
                    continue;
                }
                if (bucket.getPrimary().equals(member)) continue;
                bucket.setPrimary(INVALID_MEMBER, 1.0f);
            }
        }
        for (Member member : regionMember.values()) {
            memberId = member.getDistributedMember();
            MemberRollup memberSum = this.members.get(memberId);
            boolean isCritical = this.criticalMembers.contains(memberId);
            if (memberSum == null) {
                memberSum = new MemberRollup(this.addressComparor, memberId, isCritical, enforceLocalMaxMemory);
                this.members.put(memberId, memberSum);
            }
            memberSum.addColocatedMember(region, member);
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (regionBuckets[i] == null) {
                this.buckets[i] = null;
                continue;
            }
            if (this.buckets[i] == null) {
                this.buckets[i] = new BucketRollup(i);
            }
            for (Member member : regionBuckets[i].getMembersHosting()) {
                InternalDistributedMember memberId2 = member.getDistributedMember();
                this.buckets[i].addMember(this.members.get(memberId2));
            }
            if (regionBuckets[i].getPrimary() != null) {
                if (this.buckets[i].getPrimary() == null) {
                    InternalDistributedMember internalDistributedMember = regionBuckets[i].getPrimary().getDistributedMember();
                    this.buckets[i].setPrimary(this.members.get(internalDistributedMember), 0.0f);
                } else if (this.buckets[i].getPrimary() != INVALID_MEMBER && !this.buckets[i].getPrimary().getDistributedMember().equals(regionBuckets[i].getPrimary().getDistributedMember())) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("PartitionedRegionLoadModel - Setting bucket {} to INVALID because it is the primary on two members.This could just be a race in the collocation of data. member1={} member2={}", (Object)this.buckets[i], (Object)this.buckets[i].getPrimary(), (Object)regionBuckets[i].getPrimary());
                    }
                    this.buckets[i].setPrimary(INVALID_MEMBER, 0.0f);
                }
            }
            this.buckets[i].addColocatedBucket(region, regionBuckets[i]);
        }
        Iterator<Map.Entry<InternalDistributedMember, MemberRollup>> itr = this.members.entrySet().iterator();
        while (itr.hasNext()) {
            MemberRollup memberRollup = itr.next().getValue();
            if (memberRollup.getColocatedMembers().keySet().equals(this.allColocatedRegions)) continue;
            itr.remove();
            if (logger.isDebugEnabled()) {
                logger.debug("PartitionedRegionLoadModel - removing member {} from the consideration because it doesn't have all of the colocated regions. Expected={}, was={}", (Object)memberRollup, this.allColocatedRegions, memberRollup.getColocatedMembers());
            }
            if (!memberRollup.getBuckets().isEmpty()) {
                logger.warn("PartitionedRegionLoadModel - member {} has incomplete colocation, but it has buckets for some regions. Should have colocated regions {} but had {} and contains buckets {}", new Object[]{memberRollup, this.allColocatedRegions, memberRollup.getColocatedMembers().keySet(), memberRollup.getBuckets()});
            }
            for (Bucket bucket : new HashSet<Bucket>(memberRollup.getBuckets())) {
                bucket.removeMember(memberRollup);
            }
        }
    }

    public void initialize() {
        this.resetAverages();
        this.identifyOverRedundantBuckets();
        this.initLowRedundancyBuckets();
    }

    public SortedSet<BucketRollup> getLowRedundancyBuckets() {
        return this.lowRedundancyBuckets;
    }

    public SortedSet<BucketRollup> getOverRedundancyBuckets() {
        return this.overRedundancyBuckets;
    }

    public boolean enforceUniqueZones() {
        return this.addressComparor.enforceUniqueZones();
    }

    public void ignoreLowRedundancyBucket(BucketRollup first) {
        this.lowRedundancyBuckets.remove(first);
    }

    public void ignoreOverRedundancyBucket(BucketRollup first) {
        this.overRedundancyBuckets.remove(first);
    }

    public MemberRollup getMember(InternalDistributedMember target) {
        return this.members.get(target);
    }

    public BucketRollup[] getBuckets() {
        return this.buckets;
    }

    public String getName() {
        return this.getPartitionedRegion().getFullPath();
    }

    public PartitionedRegion getPartitionedRegion() {
        return this.partitionedRegion;
    }

    private Map<String, Long> getColocatedRegionSizes(BucketRollup bucket) {
        HashMap<String, Long> colocatedRegionSizes = new HashMap<String, Long>();
        for (Map.Entry<String, Bucket> entry : bucket.getColocatedBuckets().entrySet()) {
            colocatedRegionSizes.put(entry.getKey(), entry.getValue().getBytes());
        }
        return colocatedRegionSizes;
    }

    public void createRedundantBucket(final BucketRollup bucket, final Member targetMember) {
        Map<String, Long> colocatedRegionSizes = this.getColocatedRegionSizes(bucket);
        final Move move = new Move(null, targetMember, bucket);
        this.lowRedundancyBuckets.remove(bucket);
        bucket.addMember(targetMember);
        if (bucket.getRedundancy() < this.requiredRedundancy) {
            this.lowRedundancyBuckets.add(bucket);
        }
        this.resetAverages();
        this.operator.createRedundantBucket(targetMember.getMemberId(), bucket.getId(), colocatedRegionSizes, new BucketOperator.Completion(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure() {
                PartitionedRegionLoadModel.this.attemptedBucketCreations.add(move);
                PartitionedRegionLoadModel.this.lowRedundancyBuckets.remove(bucket);
                bucket.removeMember(targetMember);
                if (bucket.getRedundancy() < PartitionedRegionLoadModel.this.requiredRedundancy) {
                    PartitionedRegionLoadModel.this.lowRedundancyBuckets.add(bucket);
                }
                PartitionedRegionLoadModel.this.resetAverages();
            }
        });
    }

    public void remoteOverRedundancyBucket(BucketRollup bucket, Member targetMember) {
        Move bestMove = new Move(null, targetMember, bucket);
        Map<String, Long> colocatedRegionSizes = this.getColocatedRegionSizes(bucket);
        if (!this.operator.removeBucket(targetMember.getMemberId(), bucket.getId(), colocatedRegionSizes)) {
            this.attemptedBucketRemoves.add(bestMove);
        } else {
            this.overRedundancyBuckets.remove(bucket);
            bucket.removeMember(targetMember);
            if (bucket.getOnlineRedundancy() > this.requiredRedundancy) {
                this.overRedundancyBuckets.add(bucket);
            }
            this.resetAverages();
        }
    }

    private void initLowRedundancyBuckets() {
        for (BucketRollup b : this.buckets) {
            if (b == null || b.getRedundancy() < 0 || b.getRedundancy() >= this.requiredRedundancy) continue;
            this.lowRedundancyBuckets.add(b);
        }
    }

    private void identifyOverRedundantBuckets() {
        this.overRedundancyBuckets = new TreeSet<Bucket>(REDUNDANCY_COMPARATOR);
        for (BucketRollup b : this.buckets) {
            if (b == null) continue;
            if (b.getOnlineRedundancy() > this.requiredRedundancy) {
                this.overRedundancyBuckets.add(b);
                continue;
            }
            this.determineOverRedundancyInZones(b);
        }
    }

    private void determineOverRedundancyInZones(BucketRollup bucketRollup) {
        HashSet<String> redundancyZonesFound = new HashSet<String>();
        for (Member member : bucketRollup.getMembersHosting()) {
            String redundancyZone = this.getRedundancyZone(member.getDistributedMember());
            if (redundancyZone == null) continue;
            if (redundancyZonesFound.contains(redundancyZone)) {
                this.overRedundancyBuckets.add(bucketRollup);
                if (bucketRollup.getOnlineRedundancy() - 1 >= bucketRollup.getRedundancy()) continue;
                this.lowRedundancyBuckets.add(bucketRollup);
                continue;
            }
            redundancyZonesFound.add(redundancyZone);
        }
    }

    public Move findBestTarget(Bucket bucket, boolean checkIPAddress) {
        float leastCost = Float.MAX_VALUE;
        Move bestMove = null;
        for (Member member : this.members.values()) {
            Move move;
            float cost;
            if (!member.willAcceptBucket(bucket, null, checkIPAddress).willAccept() || !((cost = (member.getTotalLoad() + bucket.getLoad()) / member.getWeight()) < leastCost) || this.attemptedBucketCreations.contains(move = new Move(null, member, bucket))) continue;
            leastCost = cost;
            bestMove = move;
        }
        return bestMove;
    }

    String getRedundancyZone(InternalDistributedMember memberID) {
        return this.partitionedRegion.getDistributionManager().getRedundancyZone(memberID);
    }

    Set<String> getPreferredDeletionZone(Set<Member> members) {
        HashSet<String> distributionSet = new HashSet<String>();
        HashSet<String> zonesToDeleteFrom = new HashSet<String>();
        for (Member member : members) {
            String zoneName = this.getRedundancyZone(member.getMemberId());
            if (distributionSet.contains(zoneName)) {
                zonesToDeleteFrom.add(zoneName);
                continue;
            }
            distributionSet.add(zoneName);
        }
        return zonesToDeleteFrom;
    }

    public Move findBestRemove(Bucket bucket) {
        float mostLoaded = Float.MIN_VALUE;
        Move bestMove = null;
        Set<Member> members = bucket.getMembersHosting();
        Set<String> zones = this.getPreferredDeletionZone(members);
        for (Member member : members) {
            Move move;
            float newLoad = (member.getTotalLoad() - bucket.getLoad()) / member.getWeight();
            if (newLoad <= mostLoaded || member.equals(bucket.getPrimary()) || !zones.isEmpty() && !zones.contains(this.getRedundancyZone(member.getMemberId())) || this.attemptedBucketRemoves.contains(move = new Move(null, member, bucket))) continue;
            mostLoaded = newLoad;
            bestMove = move;
        }
        return bestMove;
    }

    public Move findBestTargetForFPR(Bucket bucket, boolean checkIPAddress) {
        List<FixedPartitionAttributesImpl> fpas = this.partitionedRegion.getFixedPartitionAttributesImpl();
        if (fpas != null) {
            for (FixedPartitionAttributesImpl fpaImpl : fpas) {
                Member targetMember;
                InternalDistributedMember targetMemberID;
                if (!fpaImpl.hasBucket(bucket.getId()) || !this.members.containsKey(targetMemberID = this.partitionedRegion.getDistributionManager().getDistributionManagerId()) || !(targetMember = (Member)this.members.get(targetMemberID)).willAcceptBucket(bucket, null, checkIPAddress).willAccept()) continue;
                return new Move(null, targetMember, bucket);
            }
        }
        return null;
    }

    public boolean movePrimary(Move bestMove) {
        Member bestSource = bestMove.getSource();
        Member bestTarget = bestMove.getTarget();
        Bucket bestBucket = bestMove.getBucket();
        boolean successfulMove = this.operator.movePrimary(bestSource.getDistributedMember(), bestTarget.getDistributedMember(), bestBucket.getId());
        if (successfulMove) {
            bestBucket.setPrimary(bestTarget, bestBucket.getPrimaryLoad());
        }
        boolean entryAdded = this.attemptedPrimaryMoves.add(bestMove);
        Assert.assertTrue(entryAdded, "PartitionedRegionLoadModel.movePrimarys - excluded set is not growing, so we probably would have an infinite loop here");
        return successfulMove;
    }

    public Move findBestPrimaryMove() {
        Move bestMove = null;
        double bestImprovement = 0.0;
        for (Member member : this.members.values()) {
            for (Bucket bucket : member.getPrimaryBuckets()) {
                for (Member target : bucket.getMembersHosting()) {
                    Move move;
                    double improvement;
                    if (member.equals(target) || !((improvement = this.improvement(member.getPrimaryLoad(), member.getWeight(), target.getPrimaryLoad(), target.getWeight(), bucket.getPrimaryLoad(), this.getPrimaryAverage())) > bestImprovement) || !(improvement > this.getMinPrimaryImprovement()) || this.attemptedPrimaryMoves.contains(move = new Move(member, target, bucket))) continue;
                    bestImprovement = improvement;
                    bestMove = move;
                }
            }
        }
        return bestMove;
    }

    private float getPrimaryAverage() {
        if (this.primaryAverage == -1.0f) {
            float totalWeight = 0.0f;
            float totalPrimaryCount = 0.0f;
            for (Member member : this.members.values()) {
                totalPrimaryCount += member.getPrimaryLoad();
                totalWeight += member.getWeight();
            }
            this.primaryAverage = totalPrimaryCount / totalWeight;
        }
        return this.primaryAverage;
    }

    private float getAverageLoad() {
        if (this.averageLoad == -1.0f) {
            float totalWeight = 0.0f;
            float totalLoad = 0.0f;
            for (Member member : this.members.values()) {
                totalLoad += member.getTotalLoad();
                totalWeight += member.getWeight();
            }
            this.averageLoad = totalLoad / totalWeight;
        }
        return this.averageLoad;
    }

    private double getMinPrimaryImprovement() {
        if (this.minPrimaryImprovement + 1.0 < 1.0E-7) {
            float largestWeight = 0.0f;
            float smallestBucket = 0.0f;
            for (Member member : this.members.values()) {
                if (member.getWeight() > largestWeight) {
                    largestWeight = member.getWeight();
                }
                for (Bucket bucket : member.getPrimaryBuckets()) {
                    if (!(bucket.getPrimaryLoad() < smallestBucket) && smallestBucket != 0.0f) continue;
                    smallestBucket = bucket.getPrimaryLoad();
                }
            }
            double before = this.variance(this.getPrimaryAverage() * largestWeight + smallestBucket, largestWeight, this.getPrimaryAverage());
            double after = this.variance(this.getPrimaryAverage() * largestWeight, largestWeight, this.getPrimaryAverage());
            this.minPrimaryImprovement = (before - after) / (double)smallestBucket;
        }
        return this.minPrimaryImprovement;
    }

    private double getMinImprovement() {
        if (this.minImprovement + 1.0 < 1.0E-7) {
            float largestWeight = 0.0f;
            float smallestBucket = 0.0f;
            for (Member member : this.members.values()) {
                if (member.getWeight() > largestWeight) {
                    largestWeight = member.getWeight();
                }
                for (Bucket bucket : member.getBuckets()) {
                    if (smallestBucket != 0.0f && (!(bucket.getLoad() < smallestBucket) || bucket.getBytes() <= 0L)) continue;
                    smallestBucket = bucket.getLoad();
                }
            }
            double before = this.variance(this.getAverageLoad() * largestWeight + smallestBucket, largestWeight, this.getAverageLoad());
            double after = this.variance(this.getAverageLoad() * largestWeight, largestWeight, this.getAverageLoad());
            this.minImprovement = (before - after) / (double)smallestBucket;
        }
        return this.minImprovement;
    }

    private void resetAverages() {
        this.primaryAverage = -1.0f;
        this.averageLoad = -1.0f;
        this.minPrimaryImprovement = -1.0;
        this.minImprovement = -1.0;
    }

    private double improvement(float sLoad, float sWeight, float tLoad, float tWeight, float bucketSize, float average) {
        double vSourceBefore = this.variance(sLoad, sWeight, average);
        double vSourceAfter = this.variance(sLoad - bucketSize, sWeight, average);
        double vTargetBefore = this.variance(tLoad, tWeight, average);
        double vTargetAfter = this.variance(tLoad + bucketSize, tWeight, average);
        double improvement = vSourceBefore - vSourceAfter + vTargetBefore - vTargetAfter;
        return improvement / (double)bucketSize;
    }

    private double variance(double load, double weight, double average) {
        double deviation = load / weight - average;
        return deviation * deviation;
    }

    public Move findBestBucketMove() {
        Move bestMove = null;
        double bestImprovement = 0.0;
        for (Member member : this.members.values()) {
            for (Bucket bucket : member.getBuckets()) {
                for (Member member2 : this.members.values()) {
                    Move move;
                    double improvement;
                    if (bucket.getMembersHosting().contains(member2) || !member2.willAcceptBucket(bucket, member, true).willAccept() || !((improvement = this.improvement(member.getTotalLoad(), member.getWeight(), member2.getTotalLoad(), member2.getWeight(), bucket.getLoad(), this.getAverageLoad())) > bestImprovement) || !(improvement > this.getMinImprovement()) || this.attemptedBucketMoves.contains(move = new Move(member, member2, bucket))) continue;
                    bestImprovement = improvement;
                    bestMove = move;
                }
            }
        }
        return bestMove;
    }

    public boolean moveBucket(Move bestMove) {
        Member bestSource = bestMove.getSource();
        Member bestTarget = bestMove.getTarget();
        BucketRollup bestBucket = (BucketRollup)bestMove.getBucket();
        Map<String, Long> colocatedRegionSizes = this.getColocatedRegionSizes(bestBucket);
        boolean successfulMove = this.operator.moveBucket(bestSource.getDistributedMember(), bestTarget.getDistributedMember(), bestBucket.getId(), colocatedRegionSizes);
        if (successfulMove) {
            bestBucket.addMember(bestTarget);
            if (bestSource.equals(bestBucket.getPrimary())) {
                bestBucket.setPrimary(bestTarget, bestBucket.getPrimaryLoad());
            }
            bestBucket.removeMember(bestSource);
        }
        boolean entryAdded = this.attemptedBucketMoves.add(bestMove);
        Assert.assertTrue(entryAdded, "PartitionedRegionLoadModel.moveBuckets - excluded set is not growing, so we probably would have an infinite loop here");
        return successfulMove;
    }

    public Set<PartitionMemberInfo> getPartitionedMemberDetails(String region) {
        TreeSet<PartitionMemberInfo> result = new TreeSet<PartitionMemberInfo>();
        for (MemberRollup member : this.members.values()) {
            Member colocatedMember = member.getColocatedMember(region);
            if (colocatedMember == null) continue;
            result.add(new PartitionMemberInfoImpl(colocatedMember.getDistributedMember(), colocatedMember.getConfiguredMaxMemory(), colocatedMember.getSize(), colocatedMember.getBucketCount(), colocatedMember.getPrimaryCount()));
        }
        return result;
    }

    public double getVarianceForTest() {
        double variance = 0.0;
        for (Member member : this.members.values()) {
            variance += this.variance(member.getTotalLoad(), member.getWeight(), this.getAverageLoad());
        }
        return variance;
    }

    public double getPrimaryVarianceForTest() {
        double variance = 0.0;
        for (Member member : this.members.values()) {
            variance += this.variance(member.getPrimaryLoad(), member.getWeight(), this.getPrimaryAverage());
        }
        return variance;
    }

    public void waitForOperations() {
        this.operator.waitForOperations();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        TreeSet<Bucket> allBucketIds = new TreeSet<Bucket>(Comparator.comparingInt(Bucket::getId));
        if (this.members.isEmpty()) {
            return "";
        }
        int longestMemberId = 0;
        for (Member member : this.members.values()) {
            allBucketIds.addAll(member.getBuckets());
            int memberIdLength = member.getDistributedMember().toString().length();
            if (longestMemberId >= memberIdLength) continue;
            longestMemberId = memberIdLength;
        }
        result.append(String.format("%" + longestMemberId + "s primaries size(MB)  max(MB)", "MemberId"));
        for (Bucket bucket : allBucketIds) {
            result.append(String.format("%4s", bucket.getId()));
        }
        for (Member member : this.members.values()) {
            result.append(String.format("\n%" + longestMemberId + "s %9.0f %8.2f %8.2f", member.getDistributedMember(), Float.valueOf(member.getPrimaryLoad()), Float.valueOf((float)member.getSize() / 1048576.0f), Float.valueOf((float)member.getConfiguredMaxMemory() / 1048576.0f)));
            for (Bucket bucket : allBucketIds) {
                char symbol = member.getPrimaryBuckets().contains(bucket) ? (char)'P' : (member.getBuckets().contains(bucket) ? (char)'R' : 'X');
                result.append("   ").append(symbol);
            }
        }
        result.append(String.format("\n%" + longestMemberId + "s                            ", "#offline"));
        for (Bucket bucket : allBucketIds) {
            result.append(String.format("%4s", bucket.getOfflineMembers().size()));
        }
        return result.toString();
    }
}

