/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.wan.GatewayTransportFilter;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheServer;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.OverflowAttributes;
import org.apache.geode.internal.cache.tier.sockets.AcceptorFactory;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.ClientHealthMonitor;
import org.apache.geode.internal.cache.tier.sockets.ConnectionListener;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.statistics.StatisticsClock;

public class AcceptorBuilder
implements AcceptorFactory {
    private int port;
    private String bindAddress;
    private boolean notifyBySubscription;
    private int socketBufferSize;
    private InternalCache cache;
    private int maximumTimeBetweenPings;
    private int maxConnections;
    private int maxThreads;
    private int maximumMessageCount;
    private int messageTimeToLive;
    private ConnectionListener connectionListener;
    private boolean tcpNoDelay;
    private long timeLimitMillis;
    private SecurityService securityService;
    private StatisticsClock statisticsClock;
    private boolean isGatewayReceiver;
    private List<GatewayTransportFilter> gatewayTransportFilters = Collections.emptyList();
    private Supplier<SocketCreator> socketCreatorSupplier;
    private CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider;
    private ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider;

    public AcceptorBuilder forServer(InternalCacheServer server) {
        this.port = server.getPort();
        this.bindAddress = server.getBindAddress();
        this.notifyBySubscription = server.getNotifyBySubscription();
        this.socketBufferSize = server.getSocketBufferSize();
        this.maximumTimeBetweenPings = server.getMaximumTimeBetweenPings();
        this.cache = server.getCache();
        this.maxConnections = server.getMaxConnections();
        this.maxThreads = server.getMaxThreads();
        this.maximumMessageCount = server.getMaximumMessageCount();
        this.messageTimeToLive = server.getMessageTimeToLive();
        this.connectionListener = server.getConnectionListener();
        this.tcpNoDelay = server.getTcpNoDelay();
        this.timeLimitMillis = server.getTimeLimitMillis();
        this.securityService = server.getSecurityService();
        this.statisticsClock = server.getStatisticsClock();
        this.socketCreatorSupplier = server.getSocketCreatorSupplier();
        this.cacheClientNotifierProvider = server.getCacheClientNotifierProvider();
        this.clientHealthMonitorProvider = server.getClientHealthMonitorProvider();
        return this;
    }

    public AcceptorBuilder setIsGatewayReceiver(boolean isGatewayReceiver) {
        this.isGatewayReceiver = isGatewayReceiver;
        return this;
    }

    public AcceptorBuilder setGatewayTransportFilters(List<GatewayTransportFilter> gatewayTransportFilters) {
        this.gatewayTransportFilters = gatewayTransportFilters;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setNotifyBySubscription(boolean notifyBySubscription) {
        this.notifyBySubscription = notifyBySubscription;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setCache(InternalCache cache) {
        this.cache = cache;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setMaximumTimeBetweenPings(int maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setMaximumMessageCount(int maximumMessageCount) {
        this.maximumMessageCount = maximumMessageCount;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setMessageTimeToLive(int messageTimeToLive) {
        this.messageTimeToLive = messageTimeToLive;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setTimeLimitMillis(long timeLimitMillis) {
        this.timeLimitMillis = timeLimitMillis;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setSocketCreatorSupplier(Supplier<SocketCreator> socketCreatorSupplier) {
        this.socketCreatorSupplier = socketCreatorSupplier;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setCacheClientNotifierProvider(CacheClientNotifier.CacheClientNotifierProvider cacheClientNotifierProvider) {
        this.cacheClientNotifierProvider = cacheClientNotifierProvider;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setClientHealthMonitorProvider(ClientHealthMonitor.ClientHealthMonitorProvider clientHealthMonitorProvider) {
        this.clientHealthMonitorProvider = clientHealthMonitorProvider;
        return this;
    }

    @VisibleForTesting
    AcceptorBuilder setStatisticsClock(StatisticsClock statisticsClock) {
        this.statisticsClock = statisticsClock;
        return this;
    }

    @Override
    public Acceptor create(OverflowAttributes overflowAttributes) throws IOException {
        return new AcceptorImpl(this.port, this.bindAddress, this.notifyBySubscription, this.socketBufferSize, this.maximumTimeBetweenPings, this.cache, this.maxConnections, this.maxThreads, this.maximumMessageCount, this.messageTimeToLive, this.connectionListener, overflowAttributes, this.tcpNoDelay, this.timeLimitMillis, this.securityService, this.socketCreatorSupplier, this.cacheClientNotifierProvider, this.clientHealthMonitorProvider, this.isGatewayReceiver, this.gatewayTransportFilters, this.statisticsClock);
    }

    @VisibleForTesting
    int getPort() {
        return this.port;
    }

    @VisibleForTesting
    String getBindAddress() {
        return this.bindAddress;
    }

    @VisibleForTesting
    boolean isNotifyBySubscription() {
        return this.notifyBySubscription;
    }

    @VisibleForTesting
    int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @VisibleForTesting
    InternalCache getCache() {
        return this.cache;
    }

    @VisibleForTesting
    int getMaximumTimeBetweenPings() {
        return this.maximumTimeBetweenPings;
    }

    @VisibleForTesting
    int getMaxConnections() {
        return this.maxConnections;
    }

    @VisibleForTesting
    int getMaxThreads() {
        return this.maxThreads;
    }

    @VisibleForTesting
    int getMaximumMessageCount() {
        return this.maximumMessageCount;
    }

    @VisibleForTesting
    int getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    @VisibleForTesting
    ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    @VisibleForTesting
    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @VisibleForTesting
    long getTimeLimitMillis() {
        return this.timeLimitMillis;
    }

    @VisibleForTesting
    SecurityService getSecurityService() {
        return this.securityService;
    }

    @VisibleForTesting
    boolean isGatewayReceiver() {
        return this.isGatewayReceiver;
    }

    @VisibleForTesting
    List<GatewayTransportFilter> getGatewayTransportFilters() {
        return this.gatewayTransportFilters;
    }

    @VisibleForTesting
    Supplier<SocketCreator> getSocketCreatorSupplier() {
        return this.socketCreatorSupplier;
    }

    @VisibleForTesting
    CacheClientNotifier.CacheClientNotifierProvider getCacheClientNotifierProvider() {
        return this.cacheClientNotifierProvider;
    }

    @VisibleForTesting
    ClientHealthMonitor.ClientHealthMonitorProvider getClientHealthMonitorProvider() {
        return this.clientHealthMonitorProvider;
    }

    @VisibleForTesting
    StatisticsClock getStatisticsClock() {
        return this.statisticsClock;
    }
}

