/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientInterestMessageImpl;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;

public class ServerInterestRegistrationMessage
extends HighPriorityDistributionMessage
implements MessageWithReply {
    private ClientProxyMembershipID clientId;
    private ClientInterestMessageImpl clientMessage;
    private int processorId;

    ServerInterestRegistrationMessage(ClientProxyMembershipID clientId, ClientInterestMessageImpl clientInterestMessage) {
        this.clientId = clientId;
        this.clientMessage = clientInterestMessage;
    }

    public ServerInterestRegistrationMessage() {
    }

    static void sendInterestChange(DistributionManager dm, ClientProxyMembershipID clientId, ClientInterestMessageImpl clientInterestMessage) {
        ServerInterestRegistrationMessage registrationMessage = new ServerInterestRegistrationMessage(clientId, clientInterestMessage);
        Set<InternalDistributedMember> recipients = dm.getOtherDistributionManagerIds();
        registrationMessage.setRecipients(recipients);
        ReplyProcessor21 replyProcessor = new ReplyProcessor21(dm, recipients);
        registrationMessage.processorId = replyProcessor.getProcessorId();
        dm.putOutgoing(registrationMessage);
        try {
            replyProcessor.waitForReplies();
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        try {
            CacheClientProxy proxy;
            CacheClientNotifier clientNotifier = CacheClientNotifier.getInstance();
            if (clientNotifier != null && (proxy = clientNotifier.getClientProxy(this.clientId)) != null) {
                proxy.processInterestMessage(this.clientMessage);
            }
        }
        finally {
            ReplyMessage reply = new ReplyMessage();
            reply.setProcessorId(this.processorId);
            reply.setRecipient(this.getSender());
            try {
                dm.putOutgoing(reply);
            }
            catch (CancelException cancelException) {}
        }
    }

    public int getDSFID() {
        return -117;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
        InternalDataSerializer.invokeToData(this.clientId, out);
        InternalDataSerializer.invokeToData(this.clientMessage, out);
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
        this.clientId = new ClientProxyMembershipID();
        InternalDataSerializer.invokeFromData(this.clientId, in);
        this.clientMessage = new ClientInterestMessageImpl();
        InternalDataSerializer.invokeFromData(this.clientMessage, in);
    }
}

