/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.deployment;

import java.util.ServiceLoader;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.deployment.internal.exception.ServiceLoadingFailureException;
import org.apache.geode.internal.classloader.ClasspathService;
import org.apache.geode.internal.deployment.JarDeploymentService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

@Experimental
public class DeploymentServiceFactory {
    private static final Logger logger = LogService.getLogger();

    private static JarDeploymentService createJarDeploymentService() {
        ServiceLoader<JarDeploymentService> jarDeploymentServices = ServiceLoader.load(JarDeploymentService.class);
        if (jarDeploymentServices.iterator().hasNext()) {
            JarDeploymentService jarDeploymentService = jarDeploymentServices.iterator().next();
            return jarDeploymentService;
        }
        throw new ServiceLoadingFailureException("No implementation of JarDeploymentService could be loaded.");
    }

    private static ClasspathService createClassPathService() {
        ServiceLoader<ClasspathService> jarDeploymentServices = ServiceLoader.load(ClasspathService.class);
        if (jarDeploymentServices.iterator().hasNext()) {
            ClasspathService classpathService = jarDeploymentServices.iterator().next();
            return classpathService;
        }
        throw new ServiceLoadingFailureException("No implementation of ClasspathService could be loaded.");
    }

    public static JarDeploymentService getJarDeploymentServiceInstance() {
        return DeploymentServiceFactory.createJarDeploymentService();
    }

    public static ClasspathService getClasspathServiceInstance() {
        return DeploymentServiceFactory.createClassPathService();
    }
}

