/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.shell.TerminalSizeAware;
import org.springframework.shell.table.Aligner;
import org.springframework.shell.table.BorderSpecification;
import org.springframework.shell.table.BorderStyle;
import org.springframework.shell.table.CellMatcher;
import org.springframework.shell.table.Formatter;
import org.springframework.shell.table.SizeConstraints;
import org.springframework.shell.table.TableModel;
import org.springframework.shell.table.TextWrapper;

public class Table
implements TerminalSizeAware {
    private final int rows;
    private final int columns;
    private TableModel model;
    private Map<CellMatcher, Formatter> formatters = new LinkedHashMap<CellMatcher, Formatter>();
    private Map<CellMatcher, SizeConstraints> sizeConstraints = new LinkedHashMap<CellMatcher, SizeConstraints>();
    private Map<CellMatcher, TextWrapper> wrappers = new LinkedHashMap<CellMatcher, TextWrapper>();
    private Map<CellMatcher, Aligner> aligners = new LinkedHashMap<CellMatcher, Aligner>();
    private List<BorderSpecification> borderSpecifications = new ArrayList<BorderSpecification>();

    Table(TableModel model, LinkedHashMap<CellMatcher, Formatter> formatters, LinkedHashMap<CellMatcher, SizeConstraints> sizeConstraints, LinkedHashMap<CellMatcher, TextWrapper> wrappers, LinkedHashMap<CellMatcher, Aligner> aligners, List<BorderSpecification> borderSpecifications) {
        this.model = model;
        this.formatters = formatters;
        this.sizeConstraints = sizeConstraints;
        this.wrappers = wrappers;
        this.aligners = aligners;
        this.borderSpecifications = borderSpecifications;
        this.rows = model.getRowCount();
        this.columns = model.getColumnCount();
    }

    public TableModel getModel() {
        return this.model;
    }

    @Override
    public String render(int totalAvailableWidth) {
        int column;
        int row;
        StringBuilder result = new StringBuilder();
        int[] cellHeights = new int[this.rows];
        int[] minCellWidths = new int[this.columns];
        int[] maxCellWidths = new int[this.columns];
        String[][][] subLines = new String[this.rows][this.columns][];
        Borders borders = new Borders();
        int widthAvailableForContents = totalAvailableWidth - borders.getNumberOfVerticalBorders();
        for (row = 0; row < this.rows; ++row) {
            for (column = 0; column < this.columns; ++column) {
                Object value = this.model.getValue(row, column);
                String[] lines = this.getFormatter(row, column).format(value);
                subLines[row][column] = lines;
                SizeConstraints.Extent extent = this.getSizeConstraints(row, column).width(lines, widthAvailableForContents, this.columns);
                minCellWidths[column] = Math.max(minCellWidths[column], extent.min);
                maxCellWidths[column] = Math.max(maxCellWidths[column], extent.max);
            }
        }
        int[] cellWidths = this.computeColumnWidths(widthAvailableForContents, minCellWidths, maxCellWidths);
        for (row = 0; row < this.rows; ++row) {
            for (column = 0; column < this.columns; ++column) {
                subLines[row][column] = this.getWrapper(row, column).wrap(subLines[row][column], cellWidths[column]);
                cellHeights[row] = Math.max(cellHeights[row], subLines[row][column].length);
            }
            for (column = 0; column < this.columns; ++column) {
                for (Map.Entry<CellMatcher, Aligner> kv : this.aligners.entrySet()) {
                    if (!kv.getKey().matches(row, column, this.model)) continue;
                    subLines[row][column] = kv.getValue().align(subLines[row][column], cellWidths[column], cellHeights[row]);
                }
            }
        }
        for (row = 0; row < this.rows; ++row) {
            int before = result.length();
            for (int column2 = 0; column2 < this.columns; ++column2) {
                borders.paintCorner(row, column2, result);
                borders.paintHorizontal(row, column2, cellWidths[column2], result);
            }
            borders.paintCorner(row, this.columns, result);
            if (result.length() > before) {
                result.append('\n');
            }
            for (int subRow = 0; subRow < cellHeights[row]; ++subRow) {
                for (int column3 = 0; column3 < this.columns; ++column3) {
                    borders.paintVertical(row, column3, result);
                    String[] lines = subLines[row][column3];
                    result.append(lines[subRow]);
                }
                borders.paintVertical(row, this.columns, result);
                result.append("\n");
            }
        }
        int before = result.length();
        for (column = 0; column < this.columns; ++column) {
            borders.paintCorner(this.rows, column, result);
            borders.paintHorizontal(this.rows, column, cellWidths[column], result);
        }
        borders.paintCorner(this.rows, this.columns, result);
        if (result.length() > before) {
            result.append('\n');
        }
        return result.toString();
    }

    private int[] computeColumnWidths(int availableWidth, int[] minCellWidths, int[] maxCellWidths) {
        int[] cellWidths;
        int minTableWidth = 0;
        int maxTableWidth = 0;
        for (int column = 0; column < this.columns; ++column) {
            minTableWidth += minCellWidths[column];
            maxTableWidth += maxCellWidths[column];
        }
        if (maxTableWidth <= availableWidth) {
            cellWidths = maxCellWidths;
        } else if (minTableWidth >= availableWidth) {
            cellWidths = minCellWidths;
        } else {
            int W = availableWidth - minTableWidth;
            int D = maxTableWidth - minTableWidth;
            cellWidths = new int[this.columns];
            for (int column = 0; column < this.columns; ++column) {
                cellWidths[column] = minCellWidths[column] + W * (maxCellWidths[column] - minCellWidths[column]) / D;
            }
        }
        return cellWidths;
    }

    private TextWrapper getWrapper(int row, int column) {
        for (Map.Entry<CellMatcher, TextWrapper> kv : this.wrappers.entrySet()) {
            if (!kv.getKey().matches(row, column, this.model)) continue;
            return kv.getValue();
        }
        throw new AssertionError((Object)"Can't be reached thanks to the whole-table default");
    }

    private SizeConstraints getSizeConstraints(int row, int column) {
        for (Map.Entry<CellMatcher, SizeConstraints> kv : this.sizeConstraints.entrySet()) {
            if (!kv.getKey().matches(row, column, this.model)) continue;
            return kv.getValue();
        }
        throw new AssertionError((Object)"Can't be reached thanks to the whole-table default");
    }

    private Formatter getFormatter(int row, int column) {
        for (Map.Entry<CellMatcher, Formatter> kv : this.formatters.entrySet()) {
            if (!kv.getKey().matches(row, column, this.model)) continue;
            return kv.getValue();
        }
        throw new AssertionError((Object)"Can't be reached thanks to the whole-table default");
    }

    private class Borders {
        private char[][] verticals;
        private char[][] horizontals;
        private char[][] corners;
        private boolean[] vFillers;
        private boolean[] hFillers;

        public Borders() {
            this.verticals = new char[Table.this.rows][Table.this.columns + 1];
            this.horizontals = new char[Table.this.rows + 1][Table.this.columns];
            this.corners = new char[Table.this.rows + 1][Table.this.columns + 1];
            this.vFillers = new boolean[Table.this.columns + 1];
            this.hFillers = new boolean[Table.this.rows + 1];
            this.init();
        }

        private void init() {
            int column;
            int row;
            for (row = 0; row <= Table.this.rows; ++row) {
                for (column = 0; column <= Table.this.columns; ++column) {
                    for (BorderSpecification bs : Table.this.borderSpecifications) {
                        char horizontalThere;
                        char verticalThere;
                        if (row < Table.this.rows && (verticalThere = bs.verticals(row, column)) != '\u0000') {
                            this.verticals[row][column] = verticalThere;
                            int n = column;
                            this.vFillers[n] = this.vFillers[n] | true;
                        }
                        if (column >= Table.this.columns || (horizontalThere = bs.horizontals(row, column)) == '\u0000') continue;
                        this.horizontals[row][column] = horizontalThere;
                        int n = row;
                        this.hFillers[n] = this.hFillers[n] | true;
                    }
                }
            }
            for (row = 0; row <= Table.this.rows; ++row) {
                for (column = 0; column <= Table.this.columns; ++column) {
                    char left = column - 1 >= 0 ? this.horizontals[row][column - 1] : (char)'\u0000';
                    char right = column < Table.this.columns ? this.horizontals[row][column] : (char)'\u0000';
                    char above = row - 1 >= 0 ? this.verticals[row - 1][column] : (char)'\u0000';
                    char below = row < Table.this.rows ? this.verticals[row][column] : (char)'\u0000';
                    this.corners[row][column] = BorderStyle.intersection(above, below, left, right);
                }
            }
        }

        private void paintCorner(int row, int column, StringBuilder stringBuilder) {
            if (this.corners[row][column] != '\u0000') {
                stringBuilder.append(this.corners[row][column]);
            } else if (this.vFillers[column] && this.hFillers[row]) {
                stringBuilder.append(' ');
            }
        }

        private void paintVertical(int row, int column, StringBuilder stringBuilder) {
            if (this.verticals[row][column] != '\u0000') {
                stringBuilder.append(this.verticals[row][column]);
            } else if (this.vFillers[column]) {
                stringBuilder.append(' ');
            }
        }

        private void paintHorizontal(int row, int column, int width, StringBuilder stringBuilder) {
            block3: {
                block2: {
                    if (this.horizontals[row][column] == '\u0000') break block2;
                    for (int i = 0; i < width; ++i) {
                        stringBuilder.append(this.horizontals[row][column]);
                    }
                    break block3;
                }
                if (!this.hFillers[row]) break block3;
                for (int i = 0; i < width; ++i) {
                    stringBuilder.append(' ');
                }
            }
        }

        public int getNumberOfVerticalBorders() {
            int result = 0;
            for (boolean b : this.vFillers) {
                if (!b) continue;
                ++result;
            }
            return result;
        }
    }
}

