/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import java.util.Optional;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergRESTUtils;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergNamespaceOperationDispatcher;
import org.apache.gravitino.listener.EventBus;
import org.apache.gravitino.listener.api.event.BaseEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateNamespaceEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateNamespaceFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergCreateNamespacePreEvent;
import org.apache.gravitino.listener.api.event.IcebergDropNamespaceEvent;
import org.apache.gravitino.listener.api.event.IcebergDropNamespaceFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergDropNamespacePreEvent;
import org.apache.gravitino.listener.api.event.IcebergListNamespacesEvent;
import org.apache.gravitino.listener.api.event.IcebergListNamespacesFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergListNamespacesPreEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadNamespaceEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadNamespaceFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergLoadNamespacePreEvent;
import org.apache.gravitino.listener.api.event.IcebergNamespaceExistsEvent;
import org.apache.gravitino.listener.api.event.IcebergNamespaceExistsFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergNamespaceExistsPreEvent;
import org.apache.gravitino.listener.api.event.IcebergRegisterTableEvent;
import org.apache.gravitino.listener.api.event.IcebergRegisterTableFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergRegisterTablePreEvent;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.listener.api.event.IcebergUpdateNamespaceEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateNamespaceFailureEvent;
import org.apache.gravitino.listener.api.event.IcebergUpdateNamespacePreEvent;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;

public class IcebergNamespaceEventDispatcher
implements IcebergNamespaceOperationDispatcher {
    private IcebergNamespaceOperationDispatcher operationDispatcher;
    private EventBus eventBus;
    private String metalakeName;

    public IcebergNamespaceEventDispatcher(IcebergNamespaceOperationDispatcher operationDispatcher, EventBus eventBus, String metalakeName) {
        this.operationDispatcher = operationDispatcher;
        this.eventBus = eventBus;
        this.metalakeName = metalakeName;
    }

    @Override
    public CreateNamespaceResponse createNamespace(IcebergRequestContext context, CreateNamespaceRequest createRequest) {
        CreateNamespaceResponse createResponse;
        NameIdentifier nameIdentifier = IcebergRESTUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), createRequest.namespace());
        Optional transformedEvent = this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateNamespacePreEvent(context, nameIdentifier, createRequest));
        IcebergCreateNamespacePreEvent transformedCreateEvent = (IcebergCreateNamespacePreEvent)((Object)transformedEvent.get());
        try {
            createResponse = this.operationDispatcher.createNamespace(context, transformedCreateEvent.createNamespaceRequest());
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateNamespaceFailureEvent(context, nameIdentifier, transformedCreateEvent.createNamespaceRequest(), e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergCreateNamespaceEvent(context, nameIdentifier, transformedCreateEvent.createNamespaceRequest(), createResponse));
        return createResponse;
    }

    @Override
    public UpdateNamespacePropertiesResponse updateNamespace(IcebergRequestContext context, Namespace namespace, UpdateNamespacePropertiesRequest updateRequest) {
        UpdateNamespacePropertiesResponse updateResponse;
        NameIdentifier nameIdentifier = IcebergRESTUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), namespace);
        Optional transformedEvent = this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateNamespacePreEvent(context, nameIdentifier, updateRequest));
        IcebergUpdateNamespacePreEvent transformedUpdateEvent = (IcebergUpdateNamespacePreEvent)((Object)transformedEvent.get());
        try {
            updateResponse = this.operationDispatcher.updateNamespace(context, namespace, transformedUpdateEvent.updateNamespacePropertiesRequest());
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateNamespaceFailureEvent(context, nameIdentifier, transformedUpdateEvent.updateNamespacePropertiesRequest(), e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergUpdateNamespaceEvent(context, nameIdentifier, transformedUpdateEvent.updateNamespacePropertiesRequest(), updateResponse));
        return updateResponse;
    }

    @Override
    public void dropNamespace(IcebergRequestContext context, Namespace namespace) {
        NameIdentifier nameIdentifier = IcebergRESTUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), namespace);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropNamespacePreEvent(context, nameIdentifier));
        try {
            this.operationDispatcher.dropNamespace(context, namespace);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergDropNamespaceFailureEvent(context, nameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergDropNamespaceEvent(context, nameIdentifier));
    }

    @Override
    public GetNamespaceResponse loadNamespace(IcebergRequestContext context, Namespace namespace) {
        GetNamespaceResponse getResponse;
        NameIdentifier nameIdentifier = IcebergRESTUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), namespace);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadNamespacePreEvent(context, nameIdentifier));
        try {
            getResponse = this.operationDispatcher.loadNamespace(context, namespace);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadNamespaceFailureEvent(context, nameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergLoadNamespaceEvent(context, nameIdentifier, getResponse));
        return getResponse;
    }

    @Override
    public ListNamespacesResponse listNamespaces(IcebergRequestContext context, Namespace parentNamespace) {
        ListNamespacesResponse listResponse;
        NameIdentifier nameIdentifier = IcebergRESTUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), parentNamespace);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListNamespacesPreEvent(context, nameIdentifier));
        try {
            listResponse = this.operationDispatcher.listNamespaces(context, parentNamespace);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergListNamespacesFailureEvent(context, nameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergListNamespacesEvent(context, nameIdentifier));
        return listResponse;
    }

    @Override
    public boolean namespaceExists(IcebergRequestContext context, Namespace namespace) {
        boolean isExists;
        NameIdentifier nameIdentifier = IcebergRESTUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), namespace);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergNamespaceExistsPreEvent(context, nameIdentifier));
        try {
            isExists = this.operationDispatcher.namespaceExists(context, namespace);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergNamespaceExistsFailureEvent(context, nameIdentifier, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergNamespaceExistsEvent(context, nameIdentifier, isExists));
        return isExists;
    }

    @Override
    public LoadTableResponse registerTable(IcebergRequestContext context, Namespace namespace, RegisterTableRequest registerTableRequest) {
        LoadTableResponse loadTableResponse;
        TableIdentifier tableIdentifier = TableIdentifier.of((Namespace)namespace, (String)registerTableRequest.name());
        NameIdentifier nameIdentifier = IcebergRESTUtils.getGravitinoNameIdentifier(this.metalakeName, context.catalogName(), tableIdentifier);
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRegisterTablePreEvent(context, nameIdentifier, registerTableRequest));
        try {
            loadTableResponse = this.operationDispatcher.registerTable(context, namespace, registerTableRequest);
        }
        catch (Exception e) {
            this.eventBus.dispatchEvent((BaseEvent)new IcebergRegisterTableFailureEvent(context, nameIdentifier, registerTableRequest, e));
            throw e;
        }
        this.eventBus.dispatchEvent((BaseEvent)new IcebergRegisterTableEvent(context, nameIdentifier, registerTableRequest, loadTableResponse));
        return loadTableResponse;
    }
}

