/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.system;

import com.googlecode.aviator.exception.ExpressionRuntimeException;
import com.googlecode.aviator.lexer.token.OperatorType;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.op.OperationRuntime;
import com.googlecode.aviator.runtime.type.AviatorObject;
import java.util.Map;

public class BinaryFunction
extends AbstractFunction {
    private static final long serialVersionUID = -7543895978170666671L;
    private final OperatorType opType;

    public BinaryFunction(OperatorType opType) {
        this.opType = opType;
    }

    @Override
    public String getName() {
        return this.opType.getToken();
    }

    public OperatorType getOpType() {
        return this.opType;
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1, AviatorObject arg2) {
        return OperationRuntime.eval(arg1, arg2, env, this.opType);
    }

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        AviatorObject left = arg1;
        switch (this.opType) {
            case BIT_AND: 
            case BIT_OR: 
            case BIT_XOR: 
            case ADD: 
            case SUB: 
            case MULT: 
            case Exponent: 
            case DIV: 
            case MOD: {
                return this.throwArity(1);
            }
            case NOT: 
            case NEG: {
                return OperationRuntime.eval(left, null, env, this.opType);
            }
        }
        throw new ExpressionRuntimeException("Invalid binary operator");
    }
}

