/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.dir;

import com.lancedb.lance.namespace.util.OpenDalUtil;
import com.lancedb.lance.namespace.util.PropertyUtil;
import java.io.Serializable;
import java.util.Map;

public class DirectoryNamespaceConfig
implements Serializable {
    public static final String ROOT = "root";
    public static final String ROOT_DEFAULT = System.getProperty("user.dir");
    public static final String STORAGE_OPTIONS_PREFIX = "storage.";
    private final String root;
    private final Map<String, String> storageOptions;

    public DirectoryNamespaceConfig(Map<String, String> properties) {
        this.root = OpenDalUtil.stripTrailingSlash(PropertyUtil.propertyAsString(properties, ROOT, ROOT_DEFAULT));
        this.storageOptions = PropertyUtil.propertiesWithPrefix(properties, STORAGE_OPTIONS_PREFIX);
    }

    public String getRoot() {
        return this.root;
    }

    public Map<String, String> getStorageOptions() {
        return this.storageOptions;
    }
}

